﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Patient/Patient.master" AutoEventWireup="true" CodeBehind="PatientCheckIn.aspx.cs" Inherits="BT.Health.SchedulingWeb.Patient.PatientCheckIn" %>

<%@ Register Src="~/User_Controls/WucAjaxLoading.ascx" TagName="WucAjaxLoading" TagPrefix="uc1" %>
<%@ Register Src="~/User_Controls/wucChangeProvider.ascx" TagName="wucChangeProvider" TagPrefix="uc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <script type="text/javascript">
        // runs in Ajax panel pages
        function pageLoad(sender, args) {

            var $tbDateFrom = $('#<%= tbDateFrom.ClientID %>')
            .attr("readonly", "readonly")
            .css("text-align", "center")
            .css("cursor", "pointer");

            $tbDateFrom.datepicker({
                dateFormat: "dd MM yy",
                changeMonth: true,
                changeYear: true,
                onSelect: function (dateText, inst) {
                    // raise the text_changed event on the server
                    __doPostBack('#<%= tbDateFrom.ID %>', '');
                }
            });
            }
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <h2>Patient Appointment Check-In</h2>
            <div style="height: 20px;">
                <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
            </div>
            <uc1:WucAjaxLoading ID="WucAjaxLoading1" runat="server" />
            <div style="width: 800px; margin: 0 auto;">
                <asp:MultiView ID="mv" runat="server" ActiveViewIndex="0">
                    <asp:View ID="viewAppointments" runat="server">
                        <table style="width: 100%;">
                            <tr valign="middle">
                                <td>
                                    <h4>Current Appointments</h4>
                                </td>
                                <td style="text-align: right;">From&nbsp;<asp:TextBox ID="tbDateFrom" runat="server" ToolTip="Click to select date from which to view appointments" OnTextChanged="tbDateFrom_TextChanged"></asp:TextBox>
                                </td>
                            </tr>
                        </table>
                        <asp:ListView ID="lv" runat="server" OnItemCommand="lv_ItemCommand" OnItemDataBound="lv_ItemDataBound">
                            <EmptyDataTemplate>The patient has no Appointments to check-in or check-out</EmptyDataTemplate>
                            <ItemTemplate>
                                <tr class="gridViewRowStyle">
                                    <td runat="server" id="tdTime"></td>
                                    <td runat="server" id="tdAppointment"></td>
                                    <td runat="server" id="tdStatus"></td>
                                    <td runat="server" id="tdChildAppointments"></td>
                                    <td>
                                        <asp:LinkButton ID="lbCheckIn" runat="server" CssClass="linkWithSpace" CommandName="CheckIn" CommandArgument='<%#Eval("Id") %>' OnClientClick="return confirm('Confirm that you want to Check-In this patient/appointment');">Check In</asp:LinkButton>
                                        <asp:LinkButton ID="lbChangeProvider" runat="server" CssClass="linkWithSpace" CommandName="ChangeProvider" CommandArgument='<%#Eval("Id") %>'>Change Provider</asp:LinkButton>
                                    </td>
                                    <td>
                                        <asp:LinkButton ID="lbAppointmentKept" runat="server" CssClass="linkWithSpace" CommandName="CheckOutAsAppointmentKept" CommandArgument='<%#Eval("Id") %>' OnClientClick="return confirm('Confirm that this patient kept the appointment');" Style="display: block;">Appointment Kept</asp:LinkButton>
                                        <asp:LinkButton ID="lbAppointmentLeftWithoutBeingSeen" CssClass="linkWithSpace" runat="server" CommandName="CheckOutAsLeftWithoutBeingSeen" CommandArgument='<%#Eval("Id") %>' OnClientClick="return confirm('Confirm that this patient left without being seen');" Style="display: block;">Left without being seen</asp:LinkButton>
                                        <asp:LinkButton ID="lpAppointmentNoShow" runat="server" CssClass="linkWithSpace" CommandName="CheckOutAsNoShow" CommandArgument='<%#Eval("Id") %>' OnClientClick="return confirm('Confirm that this patient did not show up');" Style="display: block;">Patient No-Show</asp:LinkButton>
                                    </td>
                                </tr>
                            </ItemTemplate>
                            <AlternatingItemTemplate>
                                <tr class="gridViewAlternatingRowStyle">
                                    <td runat="server" id="tdTime"></td>
                                    <td runat="server" id="tdAppointment"></td>
                                    <td runat="server" id="tdStatus"></td>
                                    <td runat="server" id="tdChildAppointments"></td>
                                    <td>
                                        <asp:LinkButton ID="lbCheckIn" runat="server" CssClass="linkWithSpace" CommandName="CheckIn" CommandArgument='<%#Eval("Id") %>' OnClientClick="return confirm('Confirm that you want to Check-In this patient/appointment');">Check In</asp:LinkButton>
                                        <asp:LinkButton ID="lbChangeProvider" runat="server" CssClass="linkWithSpace" CommandName="ChangeProvider" CommandArgument='<%#Eval("Id") %>'>Change Provider</asp:LinkButton>
                                    </td>
                                    <td>
                                        <asp:LinkButton ID="lbAppointmentKept" runat="server" CssClass="linkWithSpace" CommandName="CheckOutAsAppointmentKept" CommandArgument='<%#Eval("Id") %>' OnClientClick="return confirm('Confirm that this patient kept the appointment');" Style="display: block;">Appointment Kept</asp:LinkButton>
                                        <asp:LinkButton ID="lbAppointmentLeftWithoutBeingSeen" CssClass="linkWithSpace" runat="server" CommandName="CheckOutAsLeftWithoutBeingSeen" CommandArgument='<%#Eval("Id") %>' OnClientClick="return confirm('Confirm that this patient left without being seen');" Style="display: block;">Left without being seen</asp:LinkButton>
                                        <asp:LinkButton ID="lpAppointmentNoShow" runat="server" CssClass="linkWithSpace" CommandName="CheckOutAsNoShow" CommandArgument='<%#Eval("Id") %>' OnClientClick="return confirm('Confirm that this patient did not show up');" Style="display: block;">Patient No-Show</asp:LinkButton>
                                    </td>
                                </tr>
                            </AlternatingItemTemplate>
                            <LayoutTemplate>
                                <table class="gridView" style="width: 100%; white-space: nowrap;">
                                    <thead>
                                        <th>Date/Time</th>
                                        <th>Type</th>
                                        <th>Status</th>
                                        <th>Linked to</th>
                                        <th>CheckIn</th>
                                        <th>Check Out</th>
                                    </thead>
                                    <tbody>
                                        <tr runat="server" id="itemPlaceholder"></tr>
                                    </tbody>
                                </table>
                            </LayoutTemplate>
                        </asp:ListView>
                    </asp:View>
                    <asp:View ID="viewChangeProvider" runat="server">
                        <h4>Change Provider</h4>
                        <div style="margin: 20px 0;">
                            <asp:Button ID="btnBackToAPpointments" runat="server" Text="Back to Appointments" OnClick="btnBackToAPpointments_Click" />
                        </div>
                        <uc1:wucChangeProvider ID="wucChangeProvider1" runat="server" />
                    </asp:View>
                </asp:MultiView>
            </div>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
