﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Patient/Patient.master" AutoEventWireup="true" CodeBehind="PatientAppointmentReschedule.aspx.cs" Inherits="BT.Health.SchedulingWeb.Patient.PatientAppointmentReschedule" %>

<%@ Register Src="~/User_Controls/WucAjaxLoading.ascx" TagName="WucAjaxLoading" TagPrefix="uc1" %>
<%@ Register Src="~/User_Controls/WucDateTimePicker.ascx" TagName="WucDateTimePicker" TagPrefix="uc2" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <h2>Reschedule Appointment</h2>
            <div style="height: 20px;">
                <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
            </div>
            <uc1:WucAjaxLoading ID="WucAjaxLoading1" runat="server" />
            <asp:Panel ID="pnlOriginalAppointment" runat="server" CssClass="appointmentAdd">
                <table class="tblDataEntry tblAppointmentSearch " style="margin-bottom: 10px;">
                    <thead>
                        <tr>
                            <th colspan="2">Appointment to reschedule</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Time</td>
                            <td runat="server" id="tdATime"></td>
                        </tr>
                        <tr>
                            <td>Clinic</td>
                            <td runat="server" id="tdASection"></td>
                        </tr>
                        <tr>
                            <td>Type</td>
                            <td runat="server" id="tdAType"></td>
                        </tr>
                        <!--<tr>
                            <td>High Priority</td>
                            <td runat="server" id="tdAPriority"></td>
                        </tr>-->
                        <tr>
                            <td>Resources</td>
                            <td runat="server" id="tdAResources"></td>
                        </tr>
                    </tbody>
                </table>
            </asp:Panel>
            <div class="appointmentAdd">
                <asp:MultiView ID="mvWizard" runat="server" ActiveViewIndex="0">
                    <asp:View ID="viewStage1" runat="server">
                        <table class="tblDataEntry tblAppointmentSearch ">
                            <thead>
                                <tr>
                                    <th colspan="2">Step 1 of 4 (Resources)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Preferred Time</td>
                                    <td>
                                        <uc2:WucDateTimePicker ID="WucDateTimePicker1" runat="server" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>Days ahead to search</td>
                                    <td>
                                        <asp:TextBox ID="tbDaysToSearch" runat="server" MaxLength="2" Style="text-align: right;">7</asp:TextBox></td>
                                </tr>
                                <tr>
                                    <td>Facility</td>
                                    <td>
                                        <asp:DropDownList ID="ddlFacility" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlFacility_SelectedIndexChanged"></asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Clinic</td>
                                    <td>
                                        <asp:DropDownList ID="ddlClinic" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlClinic_SelectedIndexChanged"></asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Provider</td>
                                    <td>
                                        <asp:DropDownList ID="ddlProviders" runat="server"></asp:DropDownList></td>
                                </tr>
                                <tr>
                                    <td>Room</td>
                                    <td>
                                        <asp:DropDownList ID="ddlRooms" runat="server"></asp:DropDownList></td>
                                </tr>
                                <tr>
                                    <td>Equipment</td>
                                    <td>
                                        <asp:DropDownList ID="ddlEquipment" runat="server"></asp:DropDownList></td>
                                </tr>
                                <tr>
                                    <td>Appointment Type</td>
                                    <td>
                                        <asp:DropDownList ID="ddlAppointmentType" runat="server"></asp:DropDownList></td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align: right">
                                        <asp:Button ID="btnSearchForSlots" runat="server" Text="Search for slots" OnClick="btnSearchForSlots_Click" />
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </asp:View>
                    <asp:View ID="viewStage2" runat="server">
                        <table class="tblDataEntry tblAppointmentSearch ">
                            <thead>
                                <tr>
                                    <th colspan="2">Step 2 of 4 (Select Slot)</th>
                                </tr>
                            </thead>
                            <tr>
                                <td colspan="2">
                                    <asp:Table ID="tblStep2" runat="server" class="tblDataEntry" Style="vertical-align: top; width: 500px;"></asp:Table>
                                </td>
                            </tr>
                            <tr>
                                <td>Previous No-show's</td>
                                <td>
                                    <asp:BulletedList ID="blPreviousNoShows" runat="server" BulletStyle="NotSet" DisplayMode="Text" Style="margin: 0; padding: 0; list-style: none;"></asp:BulletedList>
                                </td>
                            </tr>
                            <tr>
                                <td>Existing appointments</td>
                                <td>
                                    <asp:BulletedList ID="blExistingAppointments" runat="server" BulletStyle="NotSet" DisplayMode="Text" Style="margin: 0; padding: 0; list-style: none;"></asp:BulletedList>
                                </td>
                            </tr>
                            <tr>
                                <td>Appointment date</td>
                                <td>
                                    <asp:DropDownList ID="ddlSlotDays" AutoPostBack="true" runat="server" Style="width: 200px;" OnSelectedIndexChanged="ddlSlotDays_SelectedIndexChanged"></asp:DropDownList></td>
                            </tr>
                            <tr>
                                <td>Appointment Time</td>
                                <td>

                                    <asp:ListBox ID="lbSlots" runat="server" Style="width: 200px;"></asp:ListBox></td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Button ID="btnGotoStep1" runat="server" Text="Previous Page" OnClick="btnGotoStep1_Click" />
                                </td>
                                <td style="text-align: right;">
                                    <asp:Button ID="btnGotoStep3" runat="server" Text="Book Slot" OnClick="btnGotoStep3_Click" />
                                </td>
                            </tr>
                        </table>
                    </asp:View>
                    <asp:View ID="viewStage3" runat="server">
                        <table class="tblDataEntry tblAppointmentSearch ">
                            <thead>
                                <tr>
                                    <th colspan="2">Step 3 of 4 (Book Appointment)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="2">
                                        <asp:Table ID="tblStep3" runat="server" class="tblDataEntry" Style="vertical-align: top; width: 500px;"></asp:Table>
                                    </td>
                                </tr>
                                <!--<tr>
                                    <td>Urgency</td>
                                    <td>
                                        <asp:DropDownList ID="ddlUrgency" runat="server">
                                            <asp:ListItem Text="Non Urgent" Value="0" Selected="True" />
                                            <asp:ListItem Text="Urgent" Value="1" />
                                        </asp:DropDownList>
                                    </td>
                                </tr>-->
                                <tr>
                                    <td>Link Appointment</td>
                                    <td>
                                        <asp:DropDownList ID="ddlLinkedAppointment" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlLinkedAppointment_SelectedIndexChanged"></asp:DropDownList></td>
                                </tr>
                                <tr runat="server" id="trAppointmentRelationship" visible="false">
                                    <td>Appointment relationship</td>
                                    <td>
                                        <asp:DropDownList ID="ddlAppointmentRelationship" runat="server"></asp:DropDownList></td>
                                </tr>
                                <!--<tr>
                                    <td>High Priority for Reschedule</td>
                                    <td>
                                        <asp:DropDownList ID="ddlIsRescheduleHighPriority" runat="server">
                                            <asp:ListItem Text="No" Value="False" Selected="True" />
                                            <asp:ListItem Text="Yes" Value="True" />
                                        </asp:DropDownList></td>
                                </tr>-->
                                <tr runat="server" id="trOverbooking" visible="false">
                                    <td>Over-booking</td>
                                    <td style="color: red">You are over-booking this slot</td>
                                </tr>
                                <tr style="vertical-align: top;">
                                    <td>Notes</td>
                                    <td>
                                        <asp:TextBox ID="tbNotes" runat="server" MaxLength="1024" TextMode="MultiLine" Columns="40" Rows="10"></asp:TextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:Button ID="btnGotoStep2" runat="server" Text="Previous Page" OnClick="btnGotoStep2_Click" /></td>
                                    <td style="text-align: right">
                                        <asp:Button ID="btnGotoStep4" runat="server" Text="Confirm and Book" OnClick="btnGotoStep4_Click" /></td>
                                </tr>
                            </tbody>
                        </table>
                    </asp:View>
                    <asp:View ID="viewCommunication" runat="server">
                        <table class="tblDataEntry tblAppointmentSearch ">
                            <thead>
                                <tr>
                                    <th colspan="2">Step 4 of 4 (Communicate booking)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="2">
                                        <asp:Table ID="tblStep4" runat="server" class="tblDataEntry" Style="vertical-align: top; width: 500px;"></asp:Table>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <asp:HyperLink ID="hPatientAppointmentList" runat="server" NavigateUrl="~/Patient/PatientAppointmentList.aspx" CssClass="linkWithSpace">View Patient Appointments</asp:HyperLink>
                                        <asp:HyperLink ID="hProviderRoster" runat="server" NavigateUrl="~/Patient/ProviderRoster.aspx" CssClass="linkWithSpace">View Provider Roster</asp:HyperLink>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">&nbsp;</td>
                                </tr>
                            </tbody>
                        </table>
                    </asp:View>
                    <asp:View ID="viewBadAppointment" runat="server">
                        <h4>Unable to reschedule appointment</h4>
                        <p>The appointment cannot be rescheduled</p>
                        <asp:Label ID="lblBadAppointmentReason" runat="server"></asp:Label>
                        <asp:HyperLink ID="hPatientAppointmentList2" runat="server" CssClass="linkWithSpace">View Patient Appointments</asp:HyperLink>
                    </asp:View>
                </asp:MultiView>
            </div>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
