﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using MedRed.Services;
using Shared.Model.Config.MDWS;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services.Interfaces;

namespace BT.Health.SchedulingWeb.Patient
{
    public partial class PatientAppointmentRequestAdd : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                if (!IsPostBack)
                {
                    // must have a patient to proceed
                    UserSession userSession = Helper.GetUserSession(Page);

                    if (userSession.PatientList.GetCurrentPatient() != null)
                    {
                        ddlRequestReason.Items.Add(new ListItem("Unknown", "0"));
                        ddlRequestReason.Items.Add(new ListItem("Standard", "1"));
                        ddlRequestReason.Items.Add(new ListItem("Transfer", "2"));
                        ddlRequestReason.Items.Add(new ListItem("Cancellation", "3"));
                        ddlRequestReason.Items.Add(new ListItem("Wait List", "4"));

                        LoadFacilityDropDownListForVistaInstance();
                    }
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        /// <summary>
        /// Show all facilities for the current VistA site
        /// </summary>
        void LoadFacilityDropDownListForVistaInstance()
        {
            // Data Hierarchy :- VistA Instance -> Facility -> Clinic
            // we have the Vista Site Id, now show all facilities within it
            // We'll sort out which clinic to show later in the page process

            int siteId = UISession.Helper.GetUserSession(Page).CurrentSite.Id;
            Factory factory = Helper.GetFactory(Page);

            var facilityService = factory.GetFacilityService();

            ddlFacility.DataValueField = "Id";
            ddlFacility.DataTextField = "Name";
            ddlFacility.DataSource = (from f in facilityService.GetAll(siteId)
                                      orderby f.Name
                                      select f).ToList();

            ddlFacility.SelectedIndex = -1;
            ddlFacility.DataBind();

            if (ddlFacility.Items.Count > 0)
            {
                ddlFacility.SelectedIndex = 0;
                LoadClinicDropDownListForFaclility(ddlFacility.SelectedValueAsInt());
            }
            else
            {
                LoadClinicDropDownListForFaclility(0);
            }
        }

        /// <summary>
        /// Load all of the clinics for a facility
        /// </summary>
        /// <param name="facilityId"></param>
        void LoadClinicDropDownListForFaclility(int facilityId)
        {
            Factory factory = Helper.GetFactory(Page);
            var service = factory.GetSectionService();

            // Show Active AND Inactive clinics
            var clinics = (from f in service.GetAll(facilityId)
                           orderby f.Name
                           select f).ToList();

            if (clinics.Count > 0)
            {
                // One or more clinics to show
                ddlClinic.DataTextField = "Name";
                ddlClinic.DataValueField = "Id";
                ddlClinic.DataSource = clinics;
                ddlClinic.SelectedIndex = -1;
                ddlClinic.DataBind();

                if (ddlClinic.Items.Count > 0)
                {
                    ddlClinic.SelectedIndex = 0;
                    LoadResourcesDropDownLists(factory, ddlClinic.SelectedValueAsInt());
                    return;
                }
            }

            // display "No clinics" to user
            ddlClinic.Items.Clear();
            // ID of zero implies no clinic
            ddlClinic.Items.Add(new ListItem("No Clinics", "0"));

            LoadResourcesDropDownLists(factory, 0);
        }

        void LoadResourcesDropDownLists(Factory factory, int clinicId)
        {
            ddlProviders.Items.Clear();

            if (clinicId > 0)
            {
                UserSession userSession = Helper.GetUserSession(Page);
                int siteId = userSession.CurrentSite.Id;

                var sectionService = factory.GetSectionService();
                var clinic = sectionService.Get(clinicId);

                // get available resources for the clinic
                var resourceService = factory.GetResourceService();
                var resources = resourceService.GetAll(clinicId);

                //-----------------------------------------------
                var providerService = factory.GetProviderService();
                var providers = providerService.GetAllForSite(siteId).ToList();

                // get providers who are resources at the clinic
                var resourceProviders = (from r in resources
                                         join p in providers
                                         on r.FullfillingResourceId equals p.Id
                                         where r.Type == ResourceType.Provider
                                         orderby p.Person.LastName
                                         select new BasicResourceData
                                         {
                                             ResourceId = r.Id,
                                             ResourceType = Shared.Model.ResourceType.Provider,
                                             ResourceName = r.Name + " (" + p.Person.GetFullName() + ")"
                                         }).ToList();

                ddlProviders.DataValueField = "ResourceId";
                ddlProviders.DataTextField = "ResourceName";
                ddlProviders.DataSource = resourceProviders;
                ddlProviders.DataBind();


                if (ddlProviders.Items.Count == 0)
                    ddlProviders.Items.Add(new ListItem("No Providers", "0"));
            }
        }

        protected void ddlFacility_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                LoadClinicDropDownListForFaclility(ddlFacility.SelectedValueAsInt());
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        protected void ddlClinic_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                Factory factory = Helper.GetFactory(Page);
                LoadResourcesDropDownLists(factory, ddlClinic.SelectedValueAsInt());
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        protected void btnAddAppointmentRequest_Click(object sender, EventArgs e)
        {
            try
            {
                // save
                string vistaSiteId = UISession.Helper.GetUserSession(Page).CurrentSite.VistaSiteId;

                Shared.Model.User user = UISession.Helper.GetCurrentUserAccount(this);
                var patient = UISession.Helper.GetCurrentPatient(this);

                //-----------------------------------------
                Factory factory = Helper.GetFactory(Page);
                //-----------------------------------------
                var siteService = factory.GetSectionService();
                var clinic = siteService.Get(int.Parse(ddlClinic.SelectedValue));

                //-----------------------------------------
                var resourceService = factory.GetResourceService();
                var providerResource = resourceService.Get(ddlProviders.SelectedValueAsInt());

                //-----------------------------------------
                var service = factory.GetAppointmentService();

                var nationalSystemService = factory.GetNationalSystemService();
                //-----------------------------------------

                Shared.Model.AppointmentRequest r = null;

                DateTime? desirerdDateTime = WucDateTimePicker1.SelectedDateTimeUTC;

                if (desirerdDateTime == null)
                    throw new ApplicationException("Desired date is not valied");

                // create new request to pair with appointment
                r = new Shared.Model.AppointmentRequest();
                r.CreatingUser = user;
                r.Patient = patient;
                r.RequestMethod = Shared.Model.RequestMethod.Other;
                r.RequestedSection = clinic;
                r.DesiredDate = desirerdDateTime;

                // need to know what TIME versus desired time is??????
                r.Time = DateTime.UtcNow;

                r.RequestedResource = providerResource;
                r.Notes = tbNotes.Text.Trim();
                r.Reason = (RequestReason)Convert.ToInt32(ddlRequestReason.SelectedValue);
                r.Status = Shared.Model.RequestStatus.Pending;

                IPatientService patientService = factory.GetPatientService();
                var pat = patientService.Get(r.Patient.Id);

                r.Priority = pat.Priority();
                if (chkServiceConnected.Checked)
                {
                    if (pat.SCPercent < 50)
                        r.Priority = 1;
                }
               
                service.AddAppointmentRequest(r);
                lblMessage.Text = "Appointment Request Added";
                if (ddlRequestReason.SelectedValue == "2")
                {
                    //AddTransferCommunicationTemplate(r, clinic);
                    ExtensionMethods.AddACommunicationTemplate(r, CommunicationType.Transfer, this.Page, clinic);
                    lblMessage.Text += " (Pre Appointment Transfer Queue item added)";
                }
                else
                {
                    ExtensionMethods.AddACommunicationTemplate(r, CommunicationType.WaitingList,this.Page, clinic);
                    lblMessage.Text += " (Waiting List Queue item added)";
                    //AddWaitingListCommunicationTemplate(r, clinic);
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        //private void AddTransferCommunicationTemplate(AppointmentRequest r, Section clinic)
        //{

        //    //UserSession userSession = Helper.GetUserSession(Page);
        //    Factory factory = Helper.GetFactory(Page);
        //    MedRed.Services.Interfaces.IFacilityService facilityService = factory.GetFacilityService();
        //    MedRed.Services.Interfaces.IAppointmentService appointmentService = factory.GetAppointmentService();

        //    MedRed.Services.Interfaces.ISectionService sectionService = factory.GetSectionService();
        //    IList<CommunicationTemplate> templateList = null;
        //    Section sec = sectionService.Get(clinic.Id);
        //    templateList = sec.CommunicationTemplates;

        //    CommunicationTemplate t = null;
        //    foreach (CommunicationTemplate template in templateList)
        //    {
        //        if (template.Type == CommunicationType.Transfer)
        //        {
        //            t = template;
        //        }
        //    }

        //    if (t != null)
        //    {    //A matching communication template exists so create a queue item
        //        CommunicationQueueItem item = new CommunicationQueueItem();
        //        appointmentService.AddToCommunicationQueue(t, r);
        //        lblMessage.Text += " (Pre Appointment Transfer Queue item added)";
        //    }

        //}

        //private void AddWaitingListCommunicationTemplate(AppointmentRequest r, Section clinic)
        //{

        //    //UserSession userSession = Helper.GetUserSession(Page);
        //    Factory factory = Helper.GetFactory(Page);
        //    MedRed.Services.Interfaces.IFacilityService facilityService = factory.GetFacilityService();
        //    MedRed.Services.Interfaces.IAppointmentService appointmentService = factory.GetAppointmentService();

        //    MedRed.Services.Interfaces.ISectionService sectionService = factory.GetSectionService();
        //    IList<CommunicationTemplate> templateList = null;
        //    Section sec = sectionService.Get(clinic.Id);
        //    templateList = sec.CommunicationTemplates;

        //    CommunicationTemplate t = null;
        //    foreach (CommunicationTemplate template in templateList)
        //    {
        //        if (template.Type == CommunicationType.WaitingList)
        //        {
        //            t = template;
        //        }
        //    }

        //    if (t != null)
        //    {    //A matching communication template exists so create a queue item
        //        CommunicationQueueItem item = new CommunicationQueueItem();
        //        appointmentService.AddToCommunicationQueue(t, r);
        //        lblMessage.Text += " (Pre Appointment Queue item added)";
        //    }

        //}

        //private void AddCommunicationTemplate(AppointmentRequest r, Section clinic)
        //{
        //    try
        //    {
        //        //UserSession userSession = Helper.GetUserSession(Page);
        //        Factory factory = Helper.GetFactory(Page);
        //        MedRed.Services.Interfaces.IFacilityService facilityService = factory.GetFacilityService();
        //        MedRed.Services.Interfaces.IAppointmentService appointmentService = factory.GetAppointmentService();

        //        //Facility facility = facilityService.Get(clinic.Id);
        //        //IList<CommunicationTemplate> templateList = null;
        //        //templateList = facility.CommunicationTemplates;

        //        MedRed.Services.Interfaces.ISectionService sectionService = factory.GetSectionService();
        //        IList<CommunicationTemplate> templateList = null;
        //        Section sec = sectionService.Get(clinic.Id);
        //        templateList = sec.CommunicationTemplates;


        //        CommunicationTemplate t = null;
        //        foreach (CommunicationTemplate template in templateList)
        //        {

        //            if (template.Type == CommunicationType.WaitingList)
        //            {
        //                t = template;
        //                break;
        //            }
        //            else if (template.Type == CommunicationType.Cancellation)
        //            {
        //                t = template;
        //                break;
        //            }
        //            else if (template.Type == CommunicationType.PostAppointment)
        //            {
        //                t = template;
        //                break;
        //            }
        //            else if (template.Type == CommunicationType.PreAppointment)
        //            {
        //                t = template;
        //                break;
        //            }
        //            else if (template.Type == CommunicationType.Transfer)
        //            {
        //                t = template;
        //                break;
        //            }
        //        }

        //        if (t != null)
        //        {    //A matching communication template exists so create a queue item
        //            CommunicationQueueItem item = new CommunicationQueueItem();
        //            appointmentService.AddToCommunicationQueue(t, r);
        //            lblMessage.Text += " (Communication queue item added)";
        //        }
        //    }
        //    catch (System.Exception ex)
        //    {
        //        lblMessage.Text = ex.Message; ex.Log();
        //    }
        //}
    }
}