﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Patient/Patient.master" AutoEventWireup="true" CodeBehind="PatientAppointmentRequestAdd.aspx.cs" Inherits="BT.Health.SchedulingWeb.Patient.PatientAppointmentRequestAdd" %>

<%@ Register Src="~/User_Controls/WucAjaxLoading.ascx" TagName="WucAjaxLoading" TagPrefix="uc1" %>
<%@ Register Src="~/User_Controls/WucDateTimePicker.ascx" TagName="WucDateTimePicker" TagPrefix="uc2" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <h2>Add Appointment Request</h2>
            <div style="height: 20px;">
                <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
            </div>
            <uc1:WucAjaxLoading ID="WucAjaxLoading1" runat="server" />
            <div class="appointmentAdd">
                <table class="tblDataEntry tblAppointmentSearch">
                    <thead>
                        <tr>
                            <th colspan="2">Appointment Request Information</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Preferred Time</td>
                            <td>
                                <uc2:WucDateTimePicker ID="WucDateTimePicker1" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <td>Facility</td>
                            <td>
                                <asp:DropDownList ID="ddlFacility" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlFacility_SelectedIndexChanged"></asp:DropDownList>
                            </td>
                        </tr>
                        <tr>
                            <td>Clinic</td>
                            <td>
                                <asp:DropDownList ID="ddlClinic" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlClinic_SelectedIndexChanged"></asp:DropDownList>
                            </td>
                        </tr>
                        <tr>
                            <td>Provider</td>
                            <td>
                                <asp:DropDownList ID="ddlProviders" runat="server"></asp:DropDownList></td>
                        </tr>
                        <tr>
                            <td>Reason</td>
                            <td>
                                <asp:DropDownList ID="ddlRequestReason" runat="server">
                                </asp:DropDownList>
                            </td>

                            <tr>
                                    <td>Service connected?</td>
                                    <td>
                                        <asp:CheckBox ID="chkServiceConnected" runat="server" />
                                    </td>
                                </tr>
                            <tr>
                                <td>Notes</td>
                                <td>
                                    <asp:TextBox ID="tbNotes" runat="server" Columns="40" MaxLength="1024" Rows="8" TextMode="MultiLine"></asp:TextBox>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: right">
                                    <asp:Button ID="btnAddAppointmentRequest" runat="server" OnClick="btnAddAppointmentRequest_Click" Text="Add" />
                                </td>
                            </tr>
                    </tbody>
                </table>
            </div>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
