﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Patient/Patient.master" AutoEventWireup="true" CodeBehind="PatientAppointmentList.aspx.cs" Inherits="BT.Health.SchedulingWeb.Patient.PatientAppointmentList" %>

<%@ Register Src="~/User_Controls/WucAjaxLoading.ascx" TagName="WucAjaxLoading" TagPrefix="uc1" %>
<%@ Register Src="~/User_Controls/wucChangeProvider.ascx" TagName="wucChangeProvider" TagPrefix="uc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <script type="text/javascript">
        // runs in Ajax panel pages
        function pageLoad(sender, args) {
            //--------------------------------
            var $tbDateTimeControl = $('#<%= tbDateFrom.ClientID %>')
                .attr("readonly", "readonly")
                .css("text-align", "center")
                .css("cursor", "pointer");

            $tbDateTimeControl.datepicker({
                dateFormat: "dd MM yy",
                changeMonth: true,
                changeYear: true,
                onSelect: function (dateText, inst) {
                    // raise the text_changed event on the server
                    __doPostBack('#<%= tbDateFrom.ID %>', '');
                }
            });

            //--------------------------------

                var $tbHistoryFrom = $('#<%= tbHistoryFrom.ClientID %>')
.attr("readonly", "readonly")
.css("text-align", "center")
.css("cursor", "pointer");

            $tbHistoryFrom.datepicker({
                dateFormat: "dd MM yy",
                changeMonth: true,
                changeYear: true,
                onSelect: function (dateText, inst) {
                    // raise the text_changed event on the server
                    __doPostBack('#<%= tbHistoryFrom.ID %>', '');
                }
            });

            //--------------------------------
                var $tbHistoryTo = $('#<%= tbHistoryTo.ClientID %>')
.attr("readonly", "readonly")
.css("text-align", "center")
.css("cursor", "pointer");

            $tbHistoryTo.datepicker({
                dateFormat: "dd MM yy",
                changeMonth: true,
                changeYear: true,
                onSelect: function (dateText, inst) {
                    // raise the text_changed event on the server
                    __doPostBack('#<%= tbHistoryTo.ID %>', '');
                }
            });

            //--------------------------------
            };
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <div style="background-color: #eee; padding: 10px 4px;">
                <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl="~/Patient/PatientAppointmentAdd.aspx" CssClass="linkAsButton">Add Appointment</asp:HyperLink>&nbsp;
                <asp:HyperLink ID="HyperLink2" runat="server" NavigateUrl="~/Patient/PatientAppointmentRequestAdd.aspx" CssClass="linkAsButton">Add Appointment Request</asp:HyperLink>
                <asp:HyperLink ID="HyperLink3" runat="server" NavigateUrl="~/Patient/TeleHealth.aspx" CssClass="linkAsButton">Add TeleHealth Appointment</asp:HyperLink>
            </div>
            <uc1:WucAjaxLoading ID="WucAjaxLoading1" runat="server" />
            <div style="height: 20px;">
                <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
            </div>
            <div style="width: 800px; margin: 0 auto;">
                <div>
                    <asp:Button ID="btnViewCurrentAppointments" runat="server" Text="View Current Appointments" OnClick="btnViewCurrentAppointments_Click" />&nbsp;
                    <asp:Button ID="btnViewAppointmentRequests" runat="server" Text="View Appointments Requests" OnClick="btnViewAppointmentRequests_Click" />&nbsp;
                    <asp:Button ID="btnViewAppointmentHistory" runat="server" Text="View Appointment History" OnClick="btnViewAppointmentHistory_Click" />
                </div>
                <asp:MultiView ID="mvAppointments" runat="server" ActiveViewIndex="0">
                    <asp:View ID="viewCurrentAppointments" runat="server">
                        <table style="width: 100%;">
                            <tr valign="middle">
                                <td>
                                    <h4>Current Appointments</h4>
                                </td>
                                <td style="text-align: right;">
                                    <span style="margin-right: 10px;">Status</span><asp:DropDownList ID="ddlAppoinmentStatus" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlAppoinmentStatus_SelectedIndexChanged"></asp:DropDownList>&nbsp;From&nbsp;
                            <asp:TextBox ID="tbDateFrom" runat="server" ToolTip="Click to select date from which to view appointments" OnTextChanged="tbDateFrom_TextChanged"></asp:TextBox>
                                </td>
                            </tr>
                        </table>
                        <asp:ListView ID="lv" runat="server" OnItemCommand="lv_ItemCommand" OnItemDataBound="lv_ItemDataBound">
                            <EmptyDataTemplate>There are no current Appointments</EmptyDataTemplate>
                            <ItemTemplate>
                                <tr class="gridViewRowStyle">
                                    <td runat="server" id="tdAppointment"></td>
                                    <td runat="server" id="tdParentAppointment"></td>
                                    <td runat="server" id="tdChildAppointments"></td>
                                    <td runat="server" id="tdIsTeleHealth"></td>
                                    <td>
                                        <asp:LinkButton ID="lbChangeProvider" runat="server" CssClass="linkWithSpace">Change Provider</asp:LinkButton>
                                        <asp:HyperLink ID="hViewInProviderRoster" runat="server" CssClass="linkWithSpace">View in Provider Roster</asp:HyperLink>
                                        <asp:HyperLink ID="hRescheduleAppointment" runat="server" CssClass="linkWithSpace">Reschedule Appointment</asp:HyperLink>
                                        <asp:HyperLink ID="hCancelAppointment" runat="server" CssClass="linkWithSpace">Cancel Appointment</asp:HyperLink>
                                    </td>
                                </tr>
                            </ItemTemplate>
                            <AlternatingItemTemplate>
                                <tr class="gridViewAlternatingRowStyle">
                                    <td runat="server" id="tdAppointment"></td>
                                    <td runat="server" id="tdParentAppointment"></td>
                                    <td runat="server" id="tdChildAppointments"></td>
                                    <td runat="server" id="tdIsTeleHealth"></td>
                                    <td>
                                        <asp:LinkButton ID="lbChangeProvider" runat="server" CssClass="linkWithSpace">Change Provider</asp:LinkButton>
                                        <asp:HyperLink ID="hViewInProviderRoster" runat="server" CssClass="linkWithSpace">View in Provider Roster</asp:HyperLink>
                                        <asp:HyperLink ID="hRescheduleAppointment" runat="server" CssClass="linkWithSpace">Reschedule Appointment</asp:HyperLink>
                                        <asp:HyperLink ID="hCancelAppointment" runat="server" CssClass="linkWithSpace">Cancel Appointment</asp:HyperLink>
                                    </td>
                                </tr>
                            </AlternatingItemTemplate>
                            <LayoutTemplate>
                                <table class="gridView" style="width: 100%;">
                                    <thead>
                                        <th>Appointment</th>
                                        <th>Previous</th>
                                        <th>Following</th>
                                        <th>Tele-Health</th>
                                        <th>Actions</th>
                                    </thead>
                                    <tbody>
                                        <tr runat="server" id="itemPlaceholder"></tr>
                                    </tbody>
                                </table>
                            </LayoutTemplate>
                        </asp:ListView>
                    </asp:View>
                    <asp:View ID="viewAppointmentRequests" runat="server">
                        <table style="width: 100%;">
                            <tr>
                                <td>
                                    <h4>Outstanding Appointment Requests</h4>
                                </td>
                                <td style="text-align: right;">
                                    <asp:DropDownList ID="ddlRequestSitesDisplayed" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlRequestSitesDisplayed_SelectedIndexChanged">
                                        <asp:ListItem Text="All Sites" Value="1" Selected="True" />
                                        <asp:ListItem Text="Current Site" Value="0" />
                                    </asp:DropDownList>
                                </td>
                            </tr>
                        </table>
                        <asp:ListView ID="lvppointmentRequests" runat="server" OnItemCommand="lvppointmentRequests_ItemCommand" OnItemDataBound="lvppointmentRequests_ItemDataBound">
                            <EmptyDataTemplate>There are no outstanding Appointment Requests</EmptyDataTemplate>
                            <ItemTemplate>
                                <tr class="gridViewRowStyle">
                                    <td runat="server" id="tdRequestedTime"></td>
                                    <td runat="server" id="tdAppRequestReason"><%#Eval("Reason") %></td>
                                    <td runat="server" id="tdRequestSection"></td>
                                    <td style="text-align: center;">
                                        <asp:Label ID="lblAtAnotherSite" runat="server" Text="At another site" ForeColor="Red" Visible="false"></asp:Label><br />
                                        <asp:LinkButton ID="LinkButton1" runat="server" CssClass="linkWithSpace" CommandName="AddAppointment" CommandArgument='<%#Eval("Id") %>'>Add Appointment</asp:LinkButton>
                                    </td>
                                </tr>
                            </ItemTemplate>
                            <AlternatingItemTemplate>
                                <tr class="gridViewAlternatingRowStyle">
                                    <td runat="server" id="tdRequestedTime"></td>
                                    <td runat="server" id="tdAppRequestReason"><%#Eval("Reason") %></td>
                                    <td runat="server" id="tdRequestSection"></td>
                                    <td style="text-align: center;">
                                        <asp:Label ID="lblAtAnotherSite" runat="server" Text="At another site" ForeColor="Red" Visible="false"></asp:Label><br />
                                        <asp:LinkButton ID="LinkButton1" runat="server" CssClass="linkWithSpace" CommandName="AddAppointment" CommandArgument='<%#Eval("Id") %>'>Add Appointment</asp:LinkButton>
                                    </td>
                                </tr>
                            </AlternatingItemTemplate>
                            <LayoutTemplate>
                                <table class="gridView" style="width: 100%;">
                                    <thead>
                                        <th>Date/Time</th>
                                        <th>Reason/Type</th>
                                        <th>Clinic</th>
                                        <th>Fulfill</th>
                                    </thead>
                                    <tbody>
                                        <tr runat="server" id="itemPlaceholder"></tr>
                                    </tbody>
                                </table>
                            </LayoutTemplate>
                        </asp:ListView>
                    </asp:View>
                    <asp:View ID="viewAppointmentHistory" runat="server">
                        <h4>Appointment History</h4>
                        <div style="background-color: #eee; padding: 10px 4px;">
                            <span style="display: inline-block; margin-right: 10px;">From</span>
                            <asp:TextBox ID="tbHistoryFrom" runat="server" AutoPostBack="true" OnTextChanged="tbHistoryFrom_TextChanged"></asp:TextBox>

                            <span style="display: inline-block; margin-left: 40px; margin-right: 10px;">To</span>
                            <asp:TextBox ID="tbHistoryTo" runat="server" AutoPostBack="true" OnTextChanged="tbHistoryTo_TextChanged"></asp:TextBox>
                        </div>
                        <asp:ListView ID="lvHistory" runat="server" OnItemDataBound="lvHistory_ItemDataBound">
                            <EmptyDataTemplate>No Appointments</EmptyDataTemplate>
                            <ItemTemplate>
                                <tr class="gridViewRowStyle">
                                    <td runat="server" id="tdTime"></td>
                                    <td runat="server" id="tdStatus"></td>
                                    <td runat="server" id="tdProvider"></td>
                                    <td runat="server" id="tdActivity"></td>
                                </tr>
                            </ItemTemplate>
                            <AlternatingItemTemplate>
                                <tr class="gridViewAlternatingRowStyle">
                                    <td runat="server" id="tdTime"></td>
                                    <td runat="server" id="tdStatus"></td>
                                    <td runat="server" id="tdProvider"></td>
                                    <td runat="server" id="tdActivity"></td>
                                </tr>
                            </AlternatingItemTemplate>
                            <LayoutTemplate>
                                <table class="gridView" style="width: 100%;">
                                    <thead>
                                        <th>Date/Time</th>
                                        <th>Status</th>
                                        <th>Provider</th>
                                        <th>Activity</th>
                                    </thead>
                                    <tbody>
                                        <tr runat="server" id="itemPlaceholder"></tr>
                                    </tbody>
                                </table>
                            </LayoutTemplate>
                        </asp:ListView>
                    </asp:View>
                    <asp:View ID="viewAlterProvider" runat="server">
                        <h4>Change Provider</h4>
                        <uc1:wucChangeProvider ID="wucChangeProvider1" runat="server" />
                    </asp:View>
                </asp:MultiView>
            </div>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
