﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;
using MedRed.Services;
using Shared.Model.Config.MDWS;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services.Interfaces;
using System.Collections.ObjectModel;

namespace BT.Health.SchedulingWeb.Patient
{
    public partial class PatientAppointmentCancel : System.Web.UI.Page
    {
        /// <summary>
        /// The appointment ID to cancel
        /// </summary>
        int _appointmentIdToCancel = 0;

        //----------------------------------------------------

        #region Page and control events

        protected override void OnInit(EventArgs e)
        {
            Page.RegisterRequiresControlState(this);
            base.OnInit(e);
        }

        protected override object SaveControlState()
        {
            return new Pair(_appointmentIdToCancel, base.SaveControlState());
        }

        protected override void LoadControlState(object savedState)
        {
            Pair p = savedState as Pair;

            if (p != null)
            {
                if (p.First != null && p.First is int)
                    _appointmentIdToCancel = (int)p.First;

                base.LoadControlState(p.Second);
            }
            else
            {
                base.LoadControlState(savedState);
            }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                lblMessage.Text = string.Empty;

                if (!IsPostBack)
                {
                    BindReasonDropDown();
                    // must have a patient to proceed
                    UserSession userSession = Helper.GetUserSession(Page);

                    if (userSession.PatientList.GetCurrentPatient() != null)
                    {
                        ShowAppoinment();
                    }
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        private void BindReasonDropDown()
        {
            Factory factory = Helper.GetFactory(Page);
            INationalSystemService reasonService = factory.GetNationalSystemService();
            string vistaSiteId = UISession.Helper.GetUserSession(Page).CurrentSite.VistaSiteId;
            Collection<CancellationReason> reasons = reasonService.GetCancellationReasons(vistaSiteId);
            ddlReason.DataSource = reasons;
            ddlReason.DataValueField = "Id";
            ddlReason.DataTextField = "Name";
            ddlReason.DataBind();
            ddlReason.Items.Insert(0, new ListItem("No reason", "0"));
            ddlReason.SelectedIndex = 0;

        }

        void ShowAppoinment()
        {
            try
            {
                // verify if the appointment id is valid
                if (Request.QueryString["appointmentId"] != null)
                {
                    // get as ID
                    int appointmentId = 0;
                    int.TryParse(Request.QueryString["appointmentId"], out appointmentId);

                    if (appointmentId > 0)
                    {
                        // check it exists for patient
                        Factory factory = Helper.GetFactory(Page);

                        var appointmentService = factory.GetAppointmentService();

                        var appointment = appointmentService.Get(appointmentId);

                        if (appointment != null)
                        {
                            if (appointment.Patient.Id == Helper.GetCurrentPatient(Page).Id)
                            {
                                if (appointment.Status == AppointmentStatus.Scheduled)
                                {
                                    // show appointment to cancel
                                    tdClinic.InnerText = appointment.Section.Name;

                                    TimeZoneInfo tz = Helper.GetUserSession(Page).CurrentSite.GetTimeZoneInfo();
                                    tdDesiredDate.InnerText = appointment.Time.ToMediumFormatFromUtc(tz);

                                    tdLength.InnerText = appointment.Length.ToString();

                                    if (appointment.AppointmentType != null)
                                        tdType.InnerText = appointment.AppointmentType.Name;

                                    // show message if is high priority
                                    trHighPriorityReschedule.Visible = appointment.HighPriorityReschedule;

                                    // short notice?
                                    int daysUntilAppointnment = appointment.Time.Subtract(DateTime.UtcNow).Days;

                                    if (daysUntilAppointnment < 7)
                                        lblShortNotice.Text = "Short Notice Cancellation - within " + daysUntilAppointnment.ToString() + " day(s)";
                                    else
                                        lblShortNotice.Text = daysUntilAppointnment.ToString() + " day(s) until appointment";

                                    if (daysUntilAppointnment < 7 || appointment.HighPriorityReschedule)
                                        ddlReschedule.SelectedIndex = 1;
                                    else
                                        ddlReschedule.SelectedIndex = 0;

                                    tdIsTeleHealth.InnerText = (string.IsNullOrEmpty(appointment.TelehealthLocation)) ? "No" : "Yes";

                                    // save for later
                                    _appointmentIdToCancel = appointment.Id;

                                    // show view to cancel
                                    mv.ActiveViewIndex = 1;
                                }
                                else
                                {
                                    lblMessage.Text = "Cannot cancel can appointment with a status of " + appointment.Status.ToString();
                                }
                            }
                            else
                            {
                                lblMessage.Text = "The appointment selected for cancellation does not belong to this patient";
                            }
                        }
                        else
                        {
                            lblMessage.Text = "The appointment selected for cancellation could not be found";
                        }
                    }
                    else
                    {
                        lblMessage.Text = "The appointment selected for cancellation is invalid";
                    }
                }
                else
                {
                    lblMessage.Text = "No appointment was selected to be cancelled";
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        protected void btnCancelAppointment_Click(object sender, EventArgs e)
        {
            try
            {
                string reason = "";
                if (ddlReason.SelectedIndex > 0)
                {
                    reason = ddlReason.SelectedItem.ToString();
                }

                if (reason.Length > 0)
                {
                    Factory factory = Helper.GetFactory(Page);
                    var appointmentService = factory.GetAppointmentService();
                    var appointment = appointmentService.Get(_appointmentIdToCancel);

                    if (appointment != null)
                    {
                        TimeZoneInfo tz = Helper.GetUserSession(Page).CurrentSite.GetTimeZoneInfo();
                        string appointmentDetail = null;

                        if (appointment.Section != null)
                            appointmentDetail = "Appointment at " + appointment.Section.Name + " on " + appointment.Time.ToMediumFormatFromUtc(tz) + " is cancelled";
                        else
                            appointmentDetail = "Appointment on " + appointment.Time.ToMediumFormatFromUtc(tz) + " is cancelled";

                        appointmentService.CancelAppointment(appointment, ddlCancelledBy.SelectedItem.Value, reason, string.Empty);
                        lblMessage.Text = appointmentDetail;

                        if (ddlReschedule.SelectedValue == "1")
                            AddAppointmentRequest(appointment);

                        ExtensionMethods.AddACommunicationTemplate(appointment, CommunicationType.Cancellation, this.Page);
                        //AddCancellationCommunicationTemplate(appointment);

                        // post cancel processes
                        mv.ActiveViewIndex = 2;
                    }
                    else
                    {
                        lblMessage.Text = "Cannot find the appointment to cancel";
                    }
                }
                else
                {
                    lblMessage.Text = "Please provide a reason for the cancellation";
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }
        #endregion



        //private void AddCancellationCommunicationTemplate(Appointment r)
        //{
        //    //UserSession userSession = Helper.GetUserSession(Page);
        //    Factory factory = Helper.GetFactory(Page);
        //    MedRed.Services.Interfaces.IFacilityService facilityService = factory.GetFacilityService();
        //    MedRed.Services.Interfaces.IAppointmentService appointmentService = factory.GetAppointmentService();

        //    MedRed.Services.Interfaces.ISectionService sectionService = factory.GetSectionService();
        //    IList<CommunicationTemplate> templateList = null;
        //    Section sec = sectionService.Get(r.Section.Id);
        //    templateList = sec.CommunicationTemplates;

        //    CommunicationTemplate t = null;
        //    foreach (CommunicationTemplate template in templateList)
        //    {
        //        if (template.Type == CommunicationType.Cancellation)
        //        {
        //            t = template;
        //        }
        //    }

        //    if (t != null)
        //    {    //A matching communication template exists so create a queue item
        //        CommunicationQueueItem item = new CommunicationQueueItem();
        //        appointmentService.AddToCommunicationQueue(t, r);
        //        lblMessage.Text += " (A cancellation Queue item has been added)";
        //    }

        //}


        void AddAppointmentRequest(Appointment appointment)
        {
            try
            {
                string vistaSiteId = UISession.Helper.GetUserSession(Page).CurrentSite.VistaSiteId;

                Shared.Model.User user = UISession.Helper.GetCurrentUserAccount(this);
                var patient = appointment.Patient;

                //-----------------------------------------
                Factory factory = Helper.GetFactory(Page);
                var service = factory.GetAppointmentService();

                var nationalSystemService = factory.GetNationalSystemService();
                //-----------------------------------------

                Shared.Model.AppointmentRequest r = null;

                DateTime? desirerdDateTime = WucDateTimePicker1.SelectedDateTimeUTC;

                if (desirerdDateTime == null)
                    throw new ApplicationException("Desired date is not valied");

                // create new request to pair with appointment
                r = new Shared.Model.AppointmentRequest();
                r.CreatingUser = user;
                r.Patient = patient;
                r.RequestMethod = Shared.Model.RequestMethod.Other;
                r.RequestedSection = appointment.Section;
                r.DesiredDate = desirerdDateTime;

                // need to know what TIME versus desired time is??????
                r.Time = DateTime.UtcNow;

                foreach (var resource in appointment.Resources)
                {
                    if (resource.Type == ResourceType.Provider)
                    {
                        // pick the first provider resource
                        r.RequestedResource = resource;
                        break;
                    }
                }

                r.Notes = "Auto-Reschedule after cancellation";
                r.Reason = RequestReason.Cancellation;
                r.Status = Shared.Model.RequestStatus.Pending;

                IPatientService patientService = factory.GetPatientService();
                var pat = patientService.Get(patient.Id);

                r.Priority = pat.Priority();
                

                service.AddAppointmentRequest(r);

                lblRescheduledIndication.Text = "Appointment was rescheduled with a new Appointment Request";
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }
    }
}