﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Patient/Patient.master" AutoEventWireup="true" CodeBehind="PatientAppointmentCancel.aspx.cs" Inherits="BT.Health.SchedulingWeb.Patient.PatientAppointmentCancel" %>

<%@ Register Src="~/User_Controls/WucAjaxLoading.ascx" TagName="WucAjaxLoading" TagPrefix="uc1" %>
<%@ Register Src="~/User_Controls/WucDateTimePicker.ascx" TagName="WucDateTimePicker" TagPrefix="uc2" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <h2>Cancel Appointment</h2>
            <div style="height: 20px;">
                <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
            </div>
            <uc1:WucAjaxLoading ID="WucAjaxLoading1" runat="server" />
            <div style="width: 500px; margin: 0 auto;">
                <asp:MultiView ID="mv" runat="server">
                    <asp:View ID="viewNoAppointment" runat="server">
                        <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl="~/Patient/PatientAppointmentList.aspx">View Patient Appointments</asp:HyperLink>
                    </asp:View>
                    <asp:View ID="View2" runat="server">
                        <table class="tblDataEntry tblAppointmentSearch" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th colspan="2">Appointment Information</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Clinic</td>
                                    <td runat="server" id="tdClinic"></td>
                                </tr>
                                <tr>
                                    <td>Desired date</td>
                                    <td runat="server" id="tdDesiredDate"></td>
                                </tr>
                                <tr>
                                    <td>Appointment length</td>
                                    <td runat="server" id="tdLength"></td>
                                </tr>
                                <tr>
                                    <td>Appointment Type</td>
                                    <td runat="server" id="tdType"></td>
                                </tr>
                                <tr>
                                    <td>Tele-Health</td>
                                    <td runat="server" id="tdIsTeleHealth"></td>
                                </tr>
                                <tr>
                                    <td>Cancelled by</td>
                                    <td>
                                        <asp:DropDownList ID="ddlCancelledBy" runat="server">
                                            <asp:ListItem Text="Cancelled by patient" Value="PC" Selected="True" />
                                            <asp:ListItem Text="Cancelled by provider" Value="C" />
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Reason for cancellation</td>
                                    <td>
                                        <asp:DropDownList ID="ddlReason" runat="server" Width="278px">
                                            <asp:ListItem Text="Cancelled by patient" Value="PC" Selected="True" />
                                            <asp:ListItem Text="Cancelled by provider" Value="C" />
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <!--
                                    tr>
                                    <td>Reason for cancellation</td>
                                    <td>
                                        <asp:TextBox ID="tbReason" runat="server" TextMode="MultiLine" Columns="40" Rows="10" MaxLength="1024"></asp:TextBox></td>
                                </tr>-->
                                <tr runat="server" id="trHighPriorityReschedule">
                                    <td>High Priority</td>
                                    <td>
                                        <asp:Image ID="Image1" runat="server" AlternateText="Indicator for High Priority Reschedule" ImageUrl="~/Graphics/Exclamation.png" />&nbsp;Appointment is a High Priority for Reschedule</td>
                                </tr>
                                <tr>
                                    <td>Short notice cancellation ?</td>
                                    <td>
                                        <asp:Label ID="lblShortNotice" runat="server"></asp:Label></td>
                                </tr>
                                <tr>
                                    <td>Reschedule&nbsp;?</td>
                                    <td>
                                        <asp:DropDownList ID="ddlReschedule" runat="server">
                                            <asp:ListItem Text="No" Value="0" />
                                            <asp:ListItem Text="Yes" Value="1" Selected="True" />
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Request Time</td>
                                    <td>
                                        <uc2:WucDateTimePicker ID="WucDateTimePicker1" runat="server" />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align: right;">
                                        <asp:Button ID="btnCancelAppointment" runat="server" Text="Cancel Appointment" OnClientClick="return confirm('Are you sure you want to cancel this appointment?');" OnClick="btnCancelAppointment_Click" /></td>
                                </tr>
                            </tbody>
                        </table>
                    </asp:View>
                    <asp:View ID="viewPostCancel" runat="server">
                        <h4>Appointment Cancelled</h4>
                        <div>
                            <asp:Label ID="lblRescheduledIndication" runat="server" Text="Appointment was not rescheduled"></asp:Label>
                        </div>
                        <asp:HyperLink ID="HyperLink2" runat="server" NavigateUrl="~/Patient/PatientAppointmentList.aspx">View Patient Appointments</asp:HyperLink>
                    </asp:View>
                </asp:MultiView>
            </div>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
