﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Patient/Patient.master" AutoEventWireup="true" CodeBehind="PatientAppointmentAdd.aspx.cs" Inherits="BT.Health.SchedulingWeb.Patient.PatientAppointmentAdd" %>

<%@ Register Src="~/User_Controls/WucDateTimePicker.ascx" TagName="WucDateTimePicker" TagPrefix="uc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        .auto-style1 {
            height: 26px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <asp:MultiView ID="mvAppointmentType" runat="server" ActiveViewIndex="0">
                <asp:View ID="viewAppointment" runat="server">
                    <h2>Add Appointment
                    </h2>
                </asp:View>
                <asp:View ID="ViewWalkInAppointment" runat="server">
                    <h2>Add Walk-in Appointment</h2>
                </asp:View>
                <asp:View ID="ViewTeleHealth" runat="server">
                    <h2>Add TeleHealth Appointment</h2>
                </asp:View>
            </asp:MultiView>
            <div style="height: 20px;">
                <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
            </div>
            <div style="height: 20px;">
                <asp:UpdateProgress ID="UpdateProgressPatientSearch" runat="server" DisplayAfter="0">
                    <ProgressTemplate>
                        <span style="color: #a49d1a;">Loading</span>&nbsp;<img src="/graphics/loading.gif" alt="loading data" title="loading data" />
                    </ProgressTemplate>
                </asp:UpdateProgress>
            </div>
            <asp:Panel ID="pnlAppointmentRequest" runat="server" Visible="false" CssClass="appointmentAdd">
                <h4>Fulfill Appointment Request for</h4>
                <asp:HiddenField ID="hfAppointmentRequestId" runat="server" />
                <table class="tblDataEntry tblAppointmentSearch " style="margin-bottom: 10px;">
                    <thead>
                        <tr>
                            <th colspan="2">Appointment Request Information</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Desired date</td>
                            <td runat="server" id="tdArDesiredDate"></td>
                        </tr>
                        <tr>
                            <td>Requested Clinic</td>
                            <td runat="server" id="tdArRequestedSection"></td>
                        </tr>
                        <tr>
                            <td>Priority</td>
                            <td runat="server" id="tdArPriority"></td>
                        </tr>
                        <tr>
                            <td>Status</td>
                            <td runat="server" id="tdArStatus"></td>
                        </tr>
                        <tr>
                            <td>Reason</td>
                            <td runat="server" id="tdArReason"></td>
                        </tr>
                        <tr>
                            <td class="auto-style1">Notes</td>
                            <td runat="server" id="tdArNotes" class="auto-style1"></td>
                        </tr>
                        <tr>
                            <td>Requested Resource</td>
                            <td runat="server" id="tdArRequestedResource"></td>
                        </tr>
                    </tbody>
                </table>
            </asp:Panel>
            <div class="appointmentAdd">
                <asp:MultiView ID="mvWizard" runat="server" ActiveViewIndex="0">
                    <asp:View ID="viewStage1" runat="server">
                        <table class="tblDataEntry tblAppointmentSearch ">
                            <thead>
                                <tr>
                                    <th colspan="2">Step 1 of 4 (Resources)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Preferred Time</td>
                                    <td>
                                        <uc1:WucDateTimePicker ID="WucDateTimePicker1" runat="server" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>Days ahead to search</td>
                                    <td>
                                        <asp:TextBox ID="tbDaysToSearch" runat="server" MaxLength="2" Style="text-align: right;">7</asp:TextBox></td>
                                </tr>
                            </tbody>
                            <tbody>
                                <tr>
                                    <td>Facility</td>
                                    <td>
                                        <asp:DropDownList ID="ddlFacility" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlFacility_SelectedIndexChanged"></asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Clinic</td>
                                    <td>
                                        <asp:DropDownList ID="ddlClinic" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlClinic_SelectedIndexChanged"></asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Provider</td>
                                    <td>
                                        <asp:DropDownList ID="ddlProviders" runat="server"></asp:DropDownList></td>
                                </tr>
                                <tr>
                                    <td>Room</td>
                                    <td>
                                        <asp:DropDownList ID="ddlRooms" runat="server"></asp:DropDownList></td>
                                </tr>
                                <tr>
                                    <td>Equipment</td>
                                    <td>
                                        <asp:DropDownList ID="ddlEquipment" runat="server"></asp:DropDownList></td>
                                </tr>
                                <tr>
                                    <td>Appointment Type</td>
                                    <td>
                                        <asp:DropDownList ID="ddlAppointmentType" runat="server"></asp:DropDownList></td>
                                </tr>
                            </tbody>
                            <tbody runat="server" id="tbodyTeleHealth" class="teleHealthBody" visible="false">
                                <tr>
                                    <td>Patient Location
                                    </td>
                                    <td>
                                        <asp:TextBox ID="tbTelehealthPatientLocation" runat="server"></asp:TextBox>
                                    </td>
                                </tr>
                            </tbody>
                            <tbody>
                                <tbody>
                                    <tr>
                                        <td colspan="2" style="text-align: right">
                                            <asp:Button ID="btnSearchForSlots" runat="server" Text="Search for slots" OnClick="btnSearchForSlots_Click" />
                                        </td>
                                    </tr>
                                </tbody>
                        </table>
                    </asp:View>
                    <asp:View ID="viewStage2" runat="server">
                        <table class="tblDataEntry tblAppointmentSearch ">
                            <thead>
                                <tr>
                                    <th colspan="2">Step 2 of 4 (Select Slot)</th>
                                </tr>
                            </thead>
                            <tr>
                                <td colspan="2">
                                    <asp:Table ID="tblStep2" runat="server" class="tblDataEntry" Style="vertical-align: top; width: 500px;"></asp:Table>
                                </td>
                            </tr>
                            <tr runat="server" id="trExistingAppointments">
                                <td>Existing appointments</td>
                                <td>
                                    <asp:BulletedList ID="blExistingAppointments" runat="server" BulletStyle="NotSet" DisplayMode="Text" Style="margin: 0; padding: 0; list-style: none;"></asp:BulletedList>
                                </td>
                            </tr>
                            <tr>
                                <td>Appointment date</td>
                                <td>
                                    <asp:DropDownList ID="ddlSlotDays" AutoPostBack="true" runat="server" Style="width: 200px;" OnSelectedIndexChanged="ddlSlotDays_SelectedIndexChanged"></asp:DropDownList></td>
                            </tr>
                            <tr>
                                <td>Appointment Time</td>
                                <td>
                                    <asp:ListBox ID="lbSlots" runat="server" AutoPostBack="true" OnSelectedIndexChanged="lbSlots_SelectedIndexChanged"></asp:ListBox>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Button ID="btnGotoStep1" runat="server" Text="Previous Page" OnClick="btnGotoStep1_Click" />
                                </td>
                                <td style="text-align: right;">
                                    <asp:Button ID="btnGotoStep3" runat="server" Text="Select Slot" OnClick="btnGotoStep3_Click" />
                                </td>
                            </tr>
                        </table>
                    </asp:View>
                    <asp:View ID="viewStage3" runat="server">
                        <table class="tblDataEntry tblAppointmentSearch ">
                            <thead>
                                <tr>
                                    <th colspan="2">Step 3 of 4 (Book Appointment)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="2">
                                        <asp:Table ID="tblStep3" runat="server" class="tblDataEntry" Style="vertical-align: top; width: 500px;"></asp:Table>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Service connected?</td>
                                    <td>
                                        <!-- <asp:DropDownList ID="ddlUrgency" runat="server">
                                            <asp:ListItem Text="Non Urgent" Value="0" Selected="True" />
                                            <asp:ListItem Text="Urgent" Value="1" />
                                        </asp:DropDownList>-->
                                        <asp:CheckBox ID="chkServiceConnected" runat="server" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>Link Appointment</td>
                                    <td>
                                        <asp:DropDownList ID="ddlLinkedAppointment" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlLinkedAppointment_SelectedIndexChanged"></asp:DropDownList></td>
                                </tr>
                                <tr runat="server" id="trAppointmentRelationship" visible="false">
                                    <td>Appointment relationship</td>
                                    <td>
                                        <asp:DropDownList ID="ddlAppointmentRelationship" runat="server"></asp:DropDownList></td>
                                </tr>

                                <tr runat="server" id="trOverbooking" visible="false">
                                    <td>Over-booking</td>
                                    <td style="color: red">You are over-booking this slot</td>
                                </tr>
                                <tr style="vertical-align: top;">
                                    <td>Notes</td>
                                    <td>
                                        <asp:TextBox ID="tbNotes" runat="server" MaxLength="1024" TextMode="MultiLine" Columns="40" Rows="10"></asp:TextBox>
                                    </td>
                                </tr>
                                <tr style="vertical-align: top;">
                                    <td>Recurring</td>
                                    <td>
                                        <asp:CheckBox ID="chkRecuring" runat="server" AutoPostBack="True" OnCheckedChanged="chkRecuring_CheckedChanged" />
                                        <asp:Table ID="tblRecur" runat="server" class="tblDataEntry" Visible="false" Width="385px">
                                            <asp:TableRow>
                                                <asp:TableCell class="auto-style8">Frequency</asp:TableCell>
                                                <asp:TableCell class="auto-style9">
                                                    <asp:DropDownList ID="ddlFrequency" runat="server" DataValueField="Id" CssClass="styled-select" Enabled="True">
                                                        <asp:ListItem>Daily</asp:ListItem>
                                                        <asp:ListItem>Weekly</asp:ListItem>
                                                        <asp:ListItem>Monthly</asp:ListItem>
                                                    </asp:DropDownList>
                                                </asp:TableCell>
                                            </asp:TableRow>
                                            <asp:TableRow>
                                                <asp:TableCell class="auto-style8">Interval</asp:TableCell>
                                                <asp:TableCell class="auto-style9">

                                                    <asp:TextBox ID="txtInterval" runat="server" Width="74px" CssClass="textbox-A" Enabled="True">1</asp:TextBox>

                                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="txtInterval" ErrorMessage="  required" Font-Size="X-Small" ForeColor="Red"></asp:RequiredFieldValidator>
                                                    <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="txtInterval" ErrorMessage="Numbers only" Font-Size="XX-Small" ForeColor="Red" ValidationExpression="^\d+$"></asp:RegularExpressionValidator>

                                                </asp:TableCell>
                                            </asp:TableRow>
                                            <asp:TableRow>
                                                <asp:TableCell class="auto-style8">Period End</asp:TableCell>
                                                <asp:TableCell class="auto-style9">
                                                    <uc1:WucDateTimePicker ID="WucRecEnd" runat="server" />
                                                </asp:TableCell>
                                            </asp:TableRow>
                                        </asp:Table>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:Button ID="btnGotoStep2" runat="server" Text="Previous Page" OnClick="btnGotoStep2_Click" /></td>
                                    <td style="text-align: right">
                                        <asp:Button ID="btnGotoStep4" runat="server" Text="Confirm and Book" OnClick="btnGotoStep4_Click" /></td>
                                </tr>
                            </tbody>
                        </table>
                    </asp:View>
                    <asp:View ID="viewCommunication" runat="server">
                        <table class="tblDataEntry tblAppointmentSearch ">
                            <thead>
                                <tr>
                                    <th colspan="2">Step 4 of 4 (Communicate booking)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="2">
                                        <asp:Table ID="tblStep4" runat="server" class="tblDataEntry" Style="vertical-align: top; width: 500px;"></asp:Table>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <asp:HyperLink ID="hAddAnotherAppointment" runat="server" NavigateUrl="~/Patient/PatientAppointmentAdd.aspx" CssClass="linkWithSpace">Add another Appointment</asp:HyperLink>
                                        <asp:HyperLink ID="hPatientAppointments" runat="server" NavigateUrl="~/Patient/PatientAppointmentList.aspx" CssClass="linkWithSpace">View Patient Appointments</asp:HyperLink>
                                        <asp:HyperLink ID="hProviderRoster" runat="server" NavigateUrl="~/Patient/ProviderRoster.aspx" CssClass="linkWithSpace">View Provider Schedule</asp:HyperLink>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <asp:Label ID="lblQueueMessage" runat="server" ForeColor="Red"></asp:Label>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </asp:View>
                    <asp:View ID="viewBadAppointmentRequest" runat="server">
                        <h4>Unable to fulfill appointment</h4>
                        <p>The appointment request cannot be fulfilled with a new appointment</p>
                        <asp:Label ID="lblBadAppointmentRequestReason" runat="server"></asp:Label>
                    </asp:View>
                </asp:MultiView>
            </div>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
