﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;


using MedRed.Services;
using Shared.Model.Config.MDWS;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services.Interfaces;

namespace BT.Health.SchedulingWeb.Patient
{
    public partial class Patient : System.Web.UI.MasterPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                if (!IsPostBack)
                {
                    // show current patient
                    var patient = UISession.Helper.GetUserSession(Page).PatientList.GetCurrentPatient();

                    if (patient != null)
                    {
                        string redirectUrl = Request.Url.OriginalString;
                        var person = patient.Person;
                        if (person != null)
                        {
                            lblCurrentPatient.Text = "Patient : " + person.GetFullName() + " [ " + patient.ICN + " ]";

                            // get no-shows for last 2 years
                            Factory factory = Helper.GetFactory(Page);
                            var appointmentService = factory.GetAppointmentService();
                            DateTime utcNow = DateTime.UtcNow;
                            int yearsToCheck = 2;

                            int noShowLastTwoYears = appointmentService.GetNoShowAppointmentsForPatient(patient.Id, utcNow.AddYears(-yearsToCheck), utcNow).Count;

                            lblNoShows.Text = "Has had " +
                                noShowLastTwoYears.ToString() +
                                " no shows in the past " + yearsToCheck.ToString() +
                                " year" + (yearsToCheck > 1 ? "s" : string.Empty);

                            if (noShowLastTwoYears > 0)
                            {
                                lblNoShows.Font.Bold = true;
                                lblNoShows.ForeColor = System.Drawing.Color.Black;
                            }
                            else
                            {
                                lblNoShows.Font.Bold = false;
                                lblNoShows.ForeColor = System.Drawing.Color.Gray;
                            }
                        }
                        else
                        {
                            //RedirectToSearchPage("Peron details not found");
                            Response.Redirect("~/Patient/PatientSearch.aspx?redirect=" + Request.Url.OriginalString, false);
                            //lblCurrentPatient.Text = "Peron details not found";
                        }
                    }
                    else
                    {
                        //RedirectToSearchPage("Patient not found");
                        Response.Redirect("~/Patient/PatientSearch.aspx?redirect=" + Request.Url.OriginalString, false);
                        //lblCurrentPatient.Text = "Patient not found";
                    }
                }
            }
            catch (System.Exception ex)
            {
                ex.Log();
            }
        }

        protected void lbSelectPatient_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Patient/PatientSearch.aspx?redirect=" + Request.Url.OriginalString, false);
        }
    }
}