﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="GroupAppointmentsList.aspx.cs" Inherits="BT.Health.SchedulingWeb.Patient.GroupAppointmentsList" %>

<%@ Register Src="~/User_Controls/WucPatientAppointmentViewCalendar.ascx" TagName="WucPatientAppointmentViewCalendar" TagPrefix="uc1" %>
<%@ Register Src="~/User_Controls/WucAjaxLoading.ascx" TagName="WucAjaxLoading" TagPrefix="uc1" %>
<%@ Register Src="~/User_Controls/wucChangeProvider.ascx" TagName="wucChangeProvider" TagPrefix="uc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel2" runat="server">
        <ContentTemplate>
            <h2>Group Appointments</h2>
            <uc1:WucAjaxLoading ID="WucAjaxLoading1" runat="server" />
            <div runat="server" id="divAppointmentInfo">
                <h3 style="text-align: center;">
                    <asp:Label ID="lblAppointmentInfo" runat="server"></asp:Label>
                </h3>
            </div>
            <div style="height: 20px;overflow:hidden;">
                <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
            </div>
            <asp:MultiView ID="mv" runat="server" ActiveViewIndex="0">
                <asp:View ID="viewGroupSlots" runat="server">
                    <div style="background-color: #eee; padding: 10px 4px;">
                        <span style="display: inline-block; margin-right: 10px;">Facility</span>
                        <asp:DropDownList ID="ddlFacility" AutoPostBack="true" runat="server" OnSelectedIndexChanged="ddlFacility_SelectedIndexChanged"></asp:DropDownList>

                        <span style="display: inline-block; margin-left: 40px; margin-right: 10px;">Clinic</span>
                        <asp:DropDownList ID="ddlClinic" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlClinic_SelectedIndexChanged"></asp:DropDownList>

                        <span style="display: inline-block; margin-left: 40px; margin-right: 10px;">Provider</span>
                        <asp:DropDownList ID="ddlProvider" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlProvider_SelectedIndexChanged"></asp:DropDownList>
                    </div>
                    <div>
                        <uc1:WucPatientAppointmentViewCalendar ID="WucPatientAppointmentViewCalendar1" runat="server" />
                    </div>
                </asp:View>
                <asp:View ID="viewGroupAppointment" runat="server">
                    <div style="width: 800px; margin: 10px auto;">
                        <div style="height: 20px; margin-bottom: 10px;">
                            <asp:LinkButton ID="lbViewCalendar" runat="server" OnClick="lbViewCalendar_Click" CssClass="linkAsButton">Back to Calendar</asp:LinkButton>&nbsp;
                        <asp:LinkButton ID="lbShowPatientAddView" runat="server" OnClick="lbShowPatientAddView_Click" CssClass="linkAsButton">Add Patients</asp:LinkButton>&nbsp;
                        <asp:LinkButton ID="lbCancelAllAppointments" runat="server" CssClass="linkAsButton" OnClick="lbCancelAllAppointments_Click1">Cancel all appointments</asp:LinkButton>&nbsp;
                            <asp:LinkButton ID="lbChangeProvider" runat="server" CssClass="linkAsButton" OnClick="lbChangeProvider_Click">Change Provider</asp:LinkButton>
                        </div>
                        <div style="background-color: #eee; padding: 6px 2px; margin: 4px 0;">
                            <asp:Label ID="lblRemainingCapacity" runat="server" Text="No slots available"></asp:Label>
                        </div>
                        <asp:ListView ID="lv" runat="server" OnItemCommand="lv_ItemCommand" OnItemDataBound="lv_ItemDataBound">
                            <EmptyDataTemplate>There are no Appointments in the group</EmptyDataTemplate>
                            <ItemTemplate>
                                <tr class="gridViewRowStyle">
                                    <td>
                                        <asp:Label ID="lblPatient" runat="server"></asp:Label>
                                        <asp:HiddenField ID="hfAppointmentId" runat="server" />
                                    </td>
                                    <td runat="server" id="tdAppointmentStatus"></td>
                                    <td>
                                        <asp:LinkButton ID="lbAppointmentActions" runat="server" CssClass="linkWithSpace" CommandName="AppointmentActions" CommandArgument='<%#Eval("Id") %>'>Actions</asp:LinkButton>
                                    </td>
                                </tr>
                            </ItemTemplate>
                            <AlternatingItemTemplate>
                                <tr class="gridViewAlternatingRowStyle">
                                    <td>
                                        <asp:Label ID="lblPatient" runat="server"></asp:Label>
                                        <asp:HiddenField ID="hfAppointmentId" runat="server" />
                                    </td>
                                    <td runat="server" id="tdAppointmentStatus"></td>
                                    <td>
                                        <asp:LinkButton ID="lbAppointmentActions" runat="server" CssClass="linkWithSpace" CommandName="AppointmentActions" CommandArgument='<%#Eval("Id") %>'>Actions</asp:LinkButton>
                                    </td>
                                </tr>
                            </AlternatingItemTemplate>
                            <LayoutTemplate>
                                <table class="gridView" style="width: 100%;">
                                    <thead>
                                        <th>Patient</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </thead>
                                    <tbody>
                                        <tr runat="server" id="itemPlaceholder"></tr>
                                    </tbody>
                                </table>
                                <div style="margin-top: 4px;">
                                    The list includes patients who have been cancelled (and therefore free up a slot).
                                </div>
                            </LayoutTemplate>
                        </asp:ListView>
                    </div>
                </asp:View>
                <asp:View ID="viewStage1" runat="server">
                    <div style="width: 500px; margin: 10px auto;">
                        <div style="height: 20px; margin-bottom: 10px;">
                            <asp:LinkButton ID="lbBackToAppointmentList" runat="server" CssClass="linkAsButton" OnClick="lbBackToAppointmentList_Click">Back to Appointment List</asp:LinkButton>
                        </div>
                        <table class="tblDataEntry tblAppointmentSearch ">
                            <thead>
                                <tr>
                                    <th colspan="2">Add Patients</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Facility</td>
                                    <td runat="server" id="tdFacilityName"></td>
                                </tr>
                                <tr>
                                    <td>Clinic</td>
                                    <td runat="server" id="tdClinicName"></td>
                                </tr>
                                <tr>
                                    <td>Provider</td>
                                    <td runat="server" id="tdProviderName"></td>
                                </tr>
                                <tr>
                                    <td>Room</td>
                                    <td>
                                        <asp:DropDownList ID="ddlRooms" runat="server"></asp:DropDownList></td>
                                </tr>
                                <tr>
                                    <td>Equipment</td>
                                    <td>
                                        <asp:DropDownList ID="ddlEquipment" runat="server"></asp:DropDownList></td>
                                </tr>
                                <tr>
                                    <td>Appointment Type</td>
                                    <td>
                                        <asp:DropDownList ID="ddlAppointmentType" runat="server"></asp:DropDownList></td>
                                </tr>

                               

                                <tr>
                                    <td>Availability</td>
                                    <td>
                                        <asp:Label ID="lblAvailability" runat="server"></asp:Label></td>
                                </tr>
                                <tr>
                                    <td>Patients</td>
                                    <td>
                                        <div style="height: 240px; overflow: auto;">
                                            <asp:CheckBoxList ID="cblPatients" runat="server"></asp:CheckBoxList>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align: right;">
                                        <asp:Button ID="btnAddPatientsToGroup" runat="server" Text="Add Patients to Group" OnClick="btnAddPatientsToGroup_Click" /></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </asp:View>
                <asp:View ID="viewManagePatient" runat="server">
                    <div style="width: 500px; margin: 10px auto;">
                        <h4>Confirm Patient before performing action</h4>
                        <div style="margin: 10px 0;">
                            <asp:LinkButton ID="lbBackToAPpointmentsFromPatientView" runat="server" CssClass="linkAsButton" OnClick="lbBackToAPpointmentsFromPatientView_Click">Back to Appointment List</asp:LinkButton>
                        </div>
                        <table class="tblDataEntry" style="width: 100%;">
                            <tr>
                                <td>Name</td>
                                <td runat="server" id="tdName"></td>
                            </tr>
                            <tr>
                                <td>Address</td>
                                <td runat="server" id="tdAddress"></td>
                            </tr>
                            <tr>
                                <td>Phone</td>
                                <td runat="server" id="tdPhone"></td>
                            </tr>
                            <tr>
                                <td>Date of Birth</td>
                                <td runat="server" id="tdDateOfBirth"></td>
                            </tr>
                            <tr>
                                <td>SSN</td>
                                <td runat="server" id="tdSSN"></td>
                            </tr>
                            <tr>
                                <td>Sex</td>
                                <td runat="server" id="tdSex"></td>
                            </tr>
                            <tr>
                                <td>Marital Status</td>
                                <td runat="server" id="tdMaritalStatus"></td>
                            </tr>
                            <tr>
                                <td>Ethnicity</td>
                                <td runat="server" id="tdEthnicity"></td>
                            </tr>
                            <tr>
                                <td>Email</td>
                                <td runat="server" id="tdEMail"></td>
                            </tr>
                            <tr>
                                <td>Available Actions</td>
                                <td>
                                    <asp:LinkButton ID="lbCheckIn" runat="server" CssClass="linkWithSpace" CommandName="CheckIn" CommandArgument='<%#Eval("Id") %>' OnClientClick="return confirm('Confirm that you want to Check-In this patient/appointment');" OnClick="lbCheckIn_Click">Check In</asp:LinkButton>
                                    <asp:LinkButton ID="lbAppointmentKept" runat="server" CssClass="linkWithSpace" CommandName="CheckOutAsAppointmentKept" CommandArgument='<%#Eval("Id") %>' OnClientClick="return confirm('Confirm that this patient kept the appointment');" Style="display: block;" OnClick="lbAppointmentKept_Click">Appointment Kept</asp:LinkButton>
                                    <asp:LinkButton ID="lbAppointmentLeftWithoutBeingSeen" CssClass="linkWithSpace" runat="server" CommandName="CheckOutAsLeftWithoutBeingSeen" CommandArgument='<%#Eval("Id") %>' OnClientClick="return confirm('Confirm that this patient left without being seen');" Style="display: block;" OnClick="lbAppointmentLeftWithoutBeingSeen_Click">Left without being seen</asp:LinkButton>
                                    <asp:LinkButton ID="lpAppointmentNoShow" runat="server" CssClass="linkWithSpace" CommandName="CheckOutAsNoShow" CommandArgument='<%#Eval("Id") %>' OnClientClick="return confirm('Confirm that this patient did not show up');" Style="display: block;" OnClick="lpAppointmentNoShow_Click">Patient No-Show</asp:LinkButton>
                                    <asp:LinkButton ID="lbCancelAppointment" runat="server" CssClass="linkWithSpace" CommandName="CancelAppointment" CommandArgument='<%#Eval("Id") %>' OnClick="lbCancelAppointment_Click">Cancel Appointment</asp:LinkButton>
                                </td>
                            </tr>
                        </table>
                    </div>
                </asp:View>
                <asp:View ID="viewCancelAppoitnment" runat="server">
                    <div style="width: 500px; margin: 10px auto;">
                        <h4>Cancel a patient from the Group Appointment</h4>
                        <div style="margin: 10px 0;">
                            <asp:LinkButton ID="lbReturnToListFromCancelAppointment" runat="server" CssClass="linkAsButton" OnClick="lbReturnToListFromCancelAppointment_Click">Back to Appointment List</asp:LinkButton>
                        </div>
                        <table class="tblDataEntry tblAppointmentSearch" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th colspan="2">Cancellation Reason</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Appointment Time</td>
                                    <td>
                                        <asp:Label ID="lblAppointmentTimeBeingCancelledForPatient" runat="server"></asp:Label></td>
                                </tr>
                                <tr>
                                    <td>Cancelled by</td>
                                    <td>
                                        <asp:DropDownList ID="ddlCancelledBy" runat="server">
                                            <asp:ListItem Text="Cancelled by patient" Value="PC" Selected="True" />
                                            <asp:ListItem Text="Cancelled by provider" Value="C" />
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Reschedule&nbsp;?</td>
                                    <td>
                                        <asp:DropDownList ID="ddlReschedule" runat="server">
                                            <asp:ListItem Text="No" Value="0" />
                                            <asp:ListItem Text="Yes" Value="1" Selected="True" />
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Reason for cancellation</td>
                                    <td>
                                        <asp:TextBox ID="tbReason" runat="server" TextMode="MultiLine" Columns="40" Rows="10" MaxLength="1024"></asp:TextBox></td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align: right;">
                                        <asp:Button ID="btnCancelAppointment" runat="server" Text="Cancel Appointment" OnClientClick="return confirm('Are you sure you want to cancel this appointment?');" OnClick="btnCancelAppointment_Click" /></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </asp:View>
                <asp:View ID="viewCancelAppointments" runat="server">
                    <div style="width: 500px; margin: 10px auto;">
                        <h4>Cancel all patients from the Group Appointment</h4>
                        <div style="margin: 10px 0;">
                            <asp:LinkButton ID="lbReturnToListFromCancelAllAppointments" runat="server" CssClass="linkAsButton" OnClick="lbReturnToListFromCancelAllAppointments_Click">Back to Appointment List</asp:LinkButton>
                        </div>
                        <table class="tblDataEntry tblAppointmentSearch" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th colspan="2">Cancellation Reason</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Appointment Time</td>
                                    <td>
                                        <asp:Label ID="lblAppointmentTimeBeingCancelledForAllPatient" runat="server"></asp:Label></td>
                                </tr>
                                <tr>
                                    <td>Reschedule&nbsp;?</td>
                                    <td>
                                        <asp:DropDownList ID="ddlRescheuleGroup" runat="server">
                                            <asp:ListItem Text="No" Value="0" />
                                            <asp:ListItem Text="Yes" Value="1" Selected="True" />
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Reason for cancellation</td>
                                    <td>
                                        <asp:TextBox ID="tbGroupCancelReason" runat="server" TextMode="MultiLine" Columns="40" Rows="10" MaxLength="1024"></asp:TextBox></td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="text-align: right;">
                                        <asp:Button ID="btnCancelGroup" runat="server" Text="Cancel all Appointments" OnClientClick="return confirm('Are you sure you want to cancel all of the appointments?');" OnClick="btnCancelGroup_Click" /></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </asp:View>
                <asp:View ID="viewChangeProvider" runat="server">
                    <div style="width: 500px; margin: 10px auto;">
                        <h4>Change Provider</h4>
                        <div style="margin: 10px 0;">
                            <asp:LinkButton ID="lbReturnToAppointmentListFromChangeProvider" runat="server" CssClass="linkAsButton" OnClick="lbReturnToAppointmentListFromChangeProvider_Click">Back to Appointment List</asp:LinkButton>
                        </div>
                        <uc1:wucChangeProvider ID="wucChangeProvider1" runat="server" />
                    </div>
                </asp:View>
            </asp:MultiView>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
