﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using MedRed.Services;
using BT.Health.SchedulingWeb.UISession;



namespace BT.Health.SchedulingWeb.Patient
{
    public partial class Details : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

            UserSession userSession = Helper.GetUserSession(Page);

            string id = Request.QueryString["Id"];

            if (id != null)
            {
                Shared.Model.Patient patient;

                

                if (userSession.Instance.ConnectionType == "Default")
                {
                    patient = Factory.GetFactory(ConnectionHelper.GetDefaultConfig()).GetPatientService().Get(userSession.Instance.SiteID, id);
                }
                else
                {
                    patient = Factory.GetFactory(ConnectionHelper.GetVistAEMRConfig()).GetPatientService().Get(userSession.Instance.SiteID, id);

                }

                // Shared.Model.Patient patient = MedRed.Services.Services.GetServices(ConnectionHelper.GetDefaultConfig(), ConnectionHelper.GetConnectionFor("122000")).Patient.Load("122000",id);
               // Shared.Model.Patient patient = MedRed.Services.Services.GetServices(ConnectionHelper.GetVistAEMRConfig(), ConnectionHelper.GetConnectionFor("100")).Patient.Load("100", id);

                userSession.PatientList.Add(patient);
                userSession.PatientList.MakeCurrent(patient);

                Session["UserSession"] = userSession;
            }

        }
        public Shared.Model.Patient Search(string id)
        {
            Shared.Model.Patient patient;

            UserSession userSession = Helper.GetUserSession(Page);

            if (userSession.Instance.ConnectionType == "Default")
            {
               patient = Factory.GetFactory(ConnectionHelper.GetDefaultConfig()).GetPatientService().Get(userSession.Instance.SiteID, id);
            }
            else
            {
                patient = Factory.GetFactory(ConnectionHelper.GetVistAEMRConfig()).GetPatientService().Get(userSession.Instance.SiteID, id);
 
            }
            userSession.PatientList.Add(patient);
            userSession.PatientList.MakeCurrent(patient);

            Session["UserSession"] = userSession;

            return patient;
        }



    }
}