﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="ClinicSchedule.aspx.cs" Inherits="BT.Health.SchedulingWeb.Patient.ClinicSchedule" %>

<%@ Register Src="~/User_Controls/WucAjaxLoading.ascx" TagName="WucAjaxLoading" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <script type="text/javascript">
        // runs in Ajax panel pages
        function pageLoad(sender, args) {

            var $tbDateTimeControl = $('#<%= tbSelectDate.ClientID %>')
            .attr("readonly", "readonly")
            .css("text-align", "center")
            .css("cursor", "pointer");

            $tbDateTimeControl.datepicker({
                dateFormat: "dd MM yy",
                changeMonth: true,
                changeYear: true,
                onSelect: function (dateText, inst) {
                    // raise the text_changed event on the server
                    __doPostBack('#<%= tbSelectDate.ID %>', '');
                }
            });
            }
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <h2>Clinic Schedule</h2>
            <div style="height: 20px;">
                <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
            </div>
            <uc1:WucAjaxLoading ID="WucAjaxLoading1" runat="server" />
            <div style="background-color: #eee; padding: 10px 4px;">
                <span style="display: inline-block; margin-right: 10px;">Facility</span>
                <asp:DropDownList ID="ddlFacility" AutoPostBack="true" runat="server" OnSelectedIndexChanged="ddlFacility_SelectedIndexChanged"></asp:DropDownList>

                <span style="display: inline-block; margin-left: 40px; margin-right: 10px;">Clinic</span>
                <asp:DropDownList ID="ddlClinic" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlClinic_SelectedIndexChanged"></asp:DropDownList>
            </div>
            <div style="margin: 10px auto;">
                <asp:Button ID="btnPrevious" runat="server" Text="Previous Day" OnClick="btnPrevious_Click" />&nbsp;
                <asp:Button ID="btnThis" runat="server" Text="Today" OnClick="btnThis_Click" />&nbsp;
                <asp:TextBox ID="tbSelectDate" runat="server" AutoPostBack="true" OnTextChanged="tbSelectDate_TextChanged"></asp:TextBox>&nbsp;
                <asp:Button ID="btnNext" runat="server" Text="Next Day" OnClick="btnNext_Click" />&nbsp;&nbsp;
                <asp:DropDownList ID="ddlResourceType" runat="server" Style="width: 100px;" AutoPostBack="true" OnSelectedIndexChanged="ddlResourceType_SelectedIndexChanged"></asp:DropDownList>
            </div>
            <div style="margin: 6px 0;">
                <asp:Label ID="lblClinicHours" runat="server"></asp:Label>
            </div>
            <asp:Table ID="tbl" runat="server" CssClass="tblClinic"></asp:Table>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
