﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using MedRed.Services;
using BT.Health.SchedulingWeb.UISession;

namespace BT.Health.SchedulingWeb.Patient
{
    public partial class AppointmentList : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        public List<Appointment> Search( )
        {
            UserSession userSession = Helper.GetUserSession(Page);
   
            string dfn = "";

            if (userSession != null)
            {
                Shared.Model.Patient currentPatient = userSession.PatientList.GetCurrentPatient();

                if (currentPatient != null)
                {
                    dfn = currentPatient.GetDFNForVistASite(userSession.Instance.SiteID);
                }
            }

            MedRed.Services.Factory factory=null;

            if (userSession.Instance.ConnectionType == "Default")
            {
                factory = Factory.GetFactory(ConnectionHelper.GetDefaultConfig());
            }
            else
            {
                factory = Factory.GetFactory(ConnectionHelper.GetVistAEMRConfig());
            }

            var appointments = factory.GetPatientService().GetAppointments(userSession.Instance.SiteID, dfn, DateTime.Now.AddYears(-1), DateTime.Now.AddYears(1));

            return appointments.ToList();

        }
    }
}