﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Security;
using Shared.Model;
using MedRed.Services;
using Shared.Model.Config.MDWS;
using BT.Health.SchedulingWeb.UISession;

namespace BT.Health.SchedulingWeb
{
    public class PageUIHelper
    {
        List<UIPage> _pages = null;

        string _breadcrumbSeparator = "|";

        List<Control> _list = null;
        List<string> _pagesProcessed = null;

        Dictionary<string, string> _mosetRecentQuerystring = null;


        public PageUIHelper()
        {
        }

        void LoadData()
        {
            // load menu items from database if first time (or somehow were unloaded)
            if (_pages == null)
            {
                Factory factory = Factory.GetFactory(MDWSConfiguration_ConfigHelper.GetDefaultConfig());

                var service = factory.GetUIService();
                _pages = service.GetPages().ToList();

                _breadcrumbSeparator = System.Configuration.ConfigurationManager.AppSettings["BreadcrumbSeparator"];

                if (_breadcrumbSeparator == null)
                    _breadcrumbSeparator = ":";
            }
        }

        public string PageTitle(string pageAddress)
        {
            LoadData();

            var page = (from p in _pages
                        where (p.PageAddress) == pageAddress
                        select p).FirstOrDefault();

            if (page != null)
                return page.PageTitle;
            else
                return string.Empty;
        }

        public void RenderBreadcrumb(Page page, Control container, string pageAddress)
        {
            try
            {
                LoadData();

                var pageAddressLowered = pageAddress.ToLower();

                // get querystring lists from session or create new
                if (page.Session["PageUIHelper._mosetRecentQuerystring"] != null)
                    _mosetRecentQuerystring = page.Session["PageUIHelper._mosetRecentQuerystring"] as Dictionary<string, string>;

                if (_mosetRecentQuerystring == null)
                    _mosetRecentQuerystring = new Dictionary<string, string>();

                // save most recent querysgtring parameters for this page

                int positionOfQuestionMark = page.Request.Url.OriginalString.IndexOf("?");

                if (!_mosetRecentQuerystring.ContainsKey(pageAddressLowered))
                    _mosetRecentQuerystring.Add(pageAddressLowered, string.Empty);

                if (positionOfQuestionMark >= 0)
                    _mosetRecentQuerystring[pageAddressLowered] = page.Request.Url.OriginalString.Substring(positionOfQuestionMark);

                // save back to session
                page.Session.Add("PageUIHelper._mosetRecentQuerystring", _mosetRecentQuerystring);

                // create a list in the order of the breadcrumb
                _list = new List<Control>();

                _pagesProcessed = new List<string>();

                // include the current page at the RHS and "Home" at the LHSC:\Users\sbyard\Documents\Visual Studio 2012\Projects\Scheduling\Database\dbo
                RecursivePrependBreadcrumbItem(pageAddressLowered);

                //------------------------------------
                // render out the list in order

                foreach (var c in _list)
                {
                    container.Controls.Add(c);
                }
            }
            catch (System.Exception ex)
            {
                PrePendErrorMessage(ex.Message);

                foreach (var c in _list)
                {
                    container.Controls.Add(c);
                }
            }
        }

        void RecursivePrependBreadcrumbItem(string pageAddressLowered)
        {
            if (!_pagesProcessed.Contains(pageAddressLowered))
            {
                if (_list.Count > 0)
                    PrePendBreadcrumbSeparator();

                // get breadcrumb text of page passed
                var page = (from p in _pages
                            where p.PageAddress.ToLower() == pageAddressLowered
                            select p).FirstOrDefault();

                if (page != null)
                {
                    HyperLink h = new HyperLink();
                    _list.Insert(0, h);
                    h.Text = page.BreadcrumbText;
                    h.NavigateUrl = page.PageAddress;

                    if (_mosetRecentQuerystring.ContainsKey(pageAddressLowered))
                    {
                        if (_mosetRecentQuerystring[pageAddressLowered] != string.Empty)
                        {
                            h.NavigateUrl += _mosetRecentQuerystring[pageAddressLowered];
                        }
                    }

                    // done this - in case of infinite loops in data
                    _pagesProcessed.Add(pageAddressLowered);

                    // render parent
                    if (page.ParentPage != null)
                        RecursivePrependBreadcrumbItem(page.ParentPage.PageAddress.ToLower());
                }
                else
                {
                    PrePendErrorMessage("Page Not Registered");
                }
            }
            else
            {
                PrePendErrorMessage("Infinite loop - check database data");
            }
        }

        void PrePendBreadcrumbSeparator()
        {
            Label lbl = new Label();
            _list.Insert(0, lbl);
            lbl.Text = _breadcrumbSeparator;
        }

        void PrePendErrorMessage(string msg)
        {
            Label lbl = new Label();
            lbl.ForeColor = System.Drawing.Color.Red;
            _list.Insert(0, lbl);
            lbl.Text = msg;
        }
    }
}