﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using System.Configuration;

using MedRed.Services;
using Shared.Model.Config.MDWS;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;

namespace BT.Health.SchedulingWeb
{
    /// <summary>
    /// Holds the menu for the web site
    /// It's loaded from database on site start
    /// </summary>
    public class Menu
    {
        /// <summary>
        /// Common menu items for evey user
        /// </summary>
        static List<UIMenu> _staticMenuItems = null;

        /// <summary>
        /// a reference to the current user role actions
        /// </summary>
        UserRoleActions _actions = null;

        /*
        public event EventHandler<UIMenuEventArgs> MenuItemRendering;

        protected void OnMenuItemRendering(UIMenuEventArgs m)
        {
            EventHandler<UIMenuEventArgs> eh = MenuItemRendering;

            if (eh != null)
                eh(this, m);
        }
        */

        // list of menu items

        /// <summary>
        /// instantiate by loading menu items from database
        /// </summary>
        public Menu()
        {

        }

        /// <summary>
        /// Render the menu
        /// Each menu item will raise and event that allows the item to be modified before rendering
        /// </summary>
        /// <param name="writer"></param>
        public void RenderMenuItems(Control container)
        {
            // get the users actions to see if they can get view a menu item (i.e. access a page)
            var userSession = Helper.GetUserSession(container.Page);
            _actions = userSession.UserActions;

            // load menu items from database if first time (or somehow were unloaded)
            if (_staticMenuItems == null)
            {
                Factory factory = Factory.GetFactory(MDWSConfiguration_ConfigHelper.GetDefaultConfig());

                var menuService = factory.GetUIService();
                _staticMenuItems = menuService.GetMenus().ToList();
            }

            //-----------------------------------------------------------------
            // Render the outer <ul>
            // add a class attribute for styling
            HtmlGenericControl ulMainMenu = new HtmlGenericControl("ul");
            container.Controls.Add(ulMainMenu);

            ulMainMenu.Attributes.Add("class", "menuMain");

            //-----------------------------------------------------------------
            // get root items in Id order
            var rootItems = (from m in _staticMenuItems
                             where m.Parent == null
                             orderby m.Id
                             select m).ToList();

            // iterate the items
            foreach (var rootMenuItem in rootItems)
            {
                // check if user can see this root menu item
                if (_actions.HasAction("menu|" + rootMenuItem.Id.ToString()))
                {
                    // render root level menu item
                    Control itemContainer = RenderMenuItem(ulMainMenu, rootMenuItem);

                    //-----------------------------------------------------------------
                    // render child items
                    var childItems = (from m in _staticMenuItems
                                      where (m.Parent != null && m.Parent.Id == rootMenuItem.Id)
                                      orderby m.Id
                                      select m).ToList();

                    if (childItems.Count > 0)
                    {
                        // render a child UI to hold the sub-menu items
                        HtmlGenericControl ulSubMenu = new HtmlGenericControl("ul");
                        itemContainer.Controls.Add(ulSubMenu);

                        foreach (var childMenuItem in childItems)
                        {
                            // check if user can access the sub menu item
                            if (_actions.HasAction("menu|" + childMenuItem.Id.ToString()))
                            {
                                // render root level menu item
                                RenderMenuItem(ulSubMenu, childMenuItem);
                            }
                        }

                    }

                    //-----------------------------------------------------------------
                }
            }
        }

        Control RenderMenuItem(Control container, UIMenu menuItem)
        {
            // raise event before rendering in order to allow changes to be made
            // reinuItemRendering(new UIMenuEventArgs(menuItem));

            HtmlGenericControl li = new HtmlGenericControl("li");
            container.Controls.Add(li);

            if (menuItem.SeparatorAfter)
                li.Attributes.Add("class", "menuItemSeparatorAfter");

            // menu item - resource address
            renderMenuItemHyperlink(li, menuItem.MenuText, menuItem.ResourceAddress);

            return li;
        }

        void renderMenuItemHyperlink(Control container, string menuText, string resourceAddress)
        {
            if (resourceAddress.StartsWith("!"))
            {
                // it's an instruction
                switch (resourceAddress)
                {
                    case "!Reports":
                        string url = ConfigurationManager.AppSettings["Reporting_Uri"];

                        if (url != null && url != string.Empty)
                        {
                            // need a hyperlink that opens in a new window
                            HyperLink h = new HyperLink();
                            container.Controls.Add(h);

                            h.NavigateUrl = url;
                            // always open in same named window
                            h.Target = "Reports";
                            h.Text = menuText;
                        }
                        break;
                }
            }
            else
            {
                // it's a regular menu item or URL
                HyperLink h = new HyperLink();
                container.Controls.Add(h);

                h.NavigateUrl = resourceAddress;
                h.Text = menuText;
            }
        }
    }
}