﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using MedRed.Services;
using Shared.Model.Config.MDWS;
using BT.Health.SchedulingWeb.UISession;

namespace BT.Health.SchedulingWeb
{
    public partial class Help : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            lblMessage.Text = string.Empty;

            if (!IsPostBack)
            {
                // when in "browse" mode - allow user to go back to previous page they came from
                hPreviousPage.NavigateUrl = "~" + Request.UrlReferrer.AbsolutePath;

                // load help info for the first time
                LoadHelp();
            }
        }

        protected void lbSaveChanges_Click(object sender, EventArgs e)
        {
            SaveHelp();
        }

        void LoadHelp()
        {
            try
            {
                // attempt to log-on user
                Factory factory = Factory.GetFactory(MDWSConfiguration_ConfigHelper.GetDefaultConfig());
                var service = factory.GetUIService();
                var pages = service.GetPages().ToList();

                // load DDL with list of pages
                ddlReferencePage.DataTextField = "PageTitle";
                ddlReferencePage.DataValueField = "PageAddress";
                ddlReferencePage.DataSource = (from p in pages
                                               orderby p.PageTitle
                                               select p).ToList();

                ddlReferencePage.DataBind();

                // deselect ay DDL selection
                ddlReferencePage.SelectedIndex = -1;

                // get page we came from to set initial help page
                var page = (from p in pages
                            where p.PageAddress.ToUpper() == "~" + Request.UrlReferrer.AbsolutePath.ToUpper()
                            select p).FirstOrDefault();

                // get help ddl page item as this is the first time we load anythig
                if (page != null)
                {
                    var selectedDDlItem = ddlReferencePage.Items.FindByValue(page.PageAddress);
                    // get the selected DDL item
                    if (selectedDDlItem != null)
                        selectedDDlItem.Selected = true;
                    // load the help
                    LoadHelpForPage(page);
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        void LoadHelpForPage(string pageAddress)
        {
            try
            {
                Factory factory = Factory.GetFactory(MDWSConfiguration_ConfigHelper.GetDefaultConfig());
                var service = factory.GetUIService();
                var pages = service.GetPages().ToList();

                var page = (from p in pages
                            where p.PageAddress == pageAddress
                            select p).FirstOrDefault();

                LoadHelpForPage(page);
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        void LoadHelpForPage(UIPage page)
        {
            if (ddlReferencePage.SelectedIndex >= 0)
            {
                if (page != null)
                {
                    tbHelp.Text = page.PageHelp;
                    lblPageName.Text = "Help for page <em>" + page.PageTitle + "</em>";
                    //hGotoPage.NavigateUrl = page.PageAddress;
                    //hGotoPage.ToolTip = "Goto page " + page.PageTitle;
                    //hGotoPage.Enabled = true;
                }
                else
                {
                    tbHelp.Text = string.Empty;
                    lblPageName.Text = "Help for page <em>[page not found]</em>";
                    //hGotoPage.NavigateUrl = string.Empty;
                    //hGotoPage.ToolTip = string.Empty;
                    //hGotoPage.Enabled = false;

                    lblMessage.Text = "Cannot load Help for requested page";
                }
            }
        }

        void SaveHelp()
        {
            try
            {
                if (ddlReferencePage.SelectedIndex >= 0)
                {
                    // attempt to log-on user
                    Factory factory = Factory.GetFactory(MDWSConfiguration_ConfigHelper.GetDefaultConfig());
                    var service = factory.GetUIService();
                    var pages = service.GetPages().ToList();

                    var page = (from p in pages
                                where p.PageAddress == ddlReferencePage.SelectedValue
                                select p).FirstOrDefault();

                    if (page != null)
                    {
                        page.PageHelp = tbHelp.Text;

                        service.UpdatePage(page);

                        lblMessage.Text = "Saved";
                    }
                    else
                    {
                        lblMessage.Text = "Cannot save Help";
                    }
                }
                else
                {
                    lblMessage.Text = "Cannot save - Help page not selected";
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        protected void ddlReferencePage_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (ddlReferencePage.SelectedIndex >= 0)
            {
                LoadHelpForPage(ddlReferencePage.SelectedValue);
            }
            else
            {
                lblMessage.Text = "Cannot save - Help page not selected";
            }
        }
    }
}