﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using MedRed.Services;
using MedRed.Services.Interfaces;
using Shared.Model.Config.MDWS;
using Shared.Model;
using Shared.Model.UserRoles;
using BT.Health.SchedulingWeb.UISession;

namespace BT.Health.SchedulingWeb.Administration.Users
{
    public partial class UsersInRoles : System.Web.UI.Page
    {
        /// <summary>
        /// true to refresh list of users
        /// </summary>
        bool _refreshData = false;

        /// <summary>
        /// The currently selected role ID - used during a data bind
        /// </summary>
        int _roleId = 0;

        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                lblMessage.Text = string.Empty;

                if (!IsPostBack)
                {
                    //LoadSites();

                    LoadRolesDdl();
                    _refreshData = true;
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        protected void Page_PreRender(object sender, EventArgs e)
        {
            try
            {
                if (_refreshData)
                {
                    LoadData();
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        void LoadRolesDdl()
        {
            try
            {
                Factory factory = Helper.GetFactory(Page);
                var service = factory.GetAccountService();

                // show all but the admin role
                ddlRoles.DataSource = (from r in service.GetAllRoles()
                                       where r.Name != "Administrator"
                                       orderby r.Name
                                       select r).ToList();

                ddlRoles.DataValueField = "Id";
                ddlRoles.DataTextField = "Name";
                ddlRoles.DataBind();

                if (ddlRoles.Items.Count > 0)
                {
                    ddlRoles.SelectedIndex = 0;
                }
                else
                {
                    ddlRoles.Items.Add(new ListItem("No roles", "0"));
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        void LoadData()
        {
            try
            {
                // we MUST clear items - otherwise, binding a NULL datasource wil still show the previous items???
                lvUserRoles.Items.Clear();

                //_siteId = ddlSite.SelectedValueAsInt();
                //_cliinicId = ddlClinic.SelectedValueAsInt();
                //_cliinicId > 0 && 
                _roleId = ddlRoles.SelectedValueAsInt();

                if (_roleId > 0)
                {
                    Factory factory = Helper.GetFactory(Page);
                    var service = factory.GetAccountService();

                    // load all users
                    List<Shared.Model.User> nonAdminUsers = new List<Shared.Model.User>();

                    foreach (var user in service.GetUsers())
                    {
                        // positively test for an admin user
                        var adminUser = (from r in user.Roles
                                         where r.Role.Name == "Administrator"
                                         select r).FirstOrDefault();

                        if (adminUser == null)
                            nonAdminUsers.Add(user);
                    }

                    lvUserRoles.DataSource = (from u in nonAdminUsers
                                              orderby u.Username
                                              select u).ToList();
                }
                else
                {
                    lvUserRoles.DataSource = null;
                }

                lvUserRoles.DataBind();

                btnSaveChanges.Enabled = (lvUserRoles.Items.Count > 0);
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        protected void lvUserRoles_ItemDataBound(object sender, ListViewItemEventArgs e)
        {
            if (e.Item.ItemType == ListViewItemType.DataItem)
            {
                Shared.Model.User user = e.Item.DataItem as Shared.Model.User;
                HiddenField hfUserInRoleId = e.Item.RecursiveFindControl("hfUserInRoleId") as HiddenField;
                Label lblUserName = e.Item.RecursiveFindControl("lblUserName") as Label;
                CheckBox chkUserInRole = e.Item.RecursiveFindControl("chkUserInRole") as CheckBox;

                HiddenField hfUserId = e.Item.RecursiveFindControl("hfUserId") as HiddenField;

                if (user != null && hfUserInRoleId != null && lblUserName != null &&
                    chkUserInRole != null && hfUserId != null)
                {
                    lblUserName.Text = user.Username;
                    hfUserId.Value = user.Id.ToString();

                    // ADMIN users do not set a site or clinic and will be NULL
                    // we must check for this - all other users will have a site and licnic set

                    //(r.Site != null && r.Site.Id == _siteId) &&
                    // (r.Section != null && r.Section.Id == _cliinicId)
                    var userInRole = (from r in user.Roles
                                      where r.Role.Id == _roleId
                                      select r).FirstOrDefault();

                    if (userInRole != null)
                    {
                        chkUserInRole.Checked = true;
                        hfUserInRoleId.Value = userInRole.Id.ToString();
                    }
                }
            }
        }

        protected void btnSaveChanges_Click(object sender, EventArgs e)
        {
            try
            {
                Factory factory = Helper.GetFactory(Page);
                var service = factory.GetAccountService();
                //var siteService = factory.GetSiteService();
                //var sectionService = factory.GetSectionService();

                //--------------------------------------------------------
                /*
                var site = siteService.Get(ddlSite.SelectedValueAsInt());

                if (site == null)
                {
                    lblMessage.Text = "site not selected";
                    return;
                }

                //--------------------------------------------------------
                var clinic = sectionService.Get(ddlClinic.SelectedValueAsInt());

                if (clinic == null)
                {
                    lblMessage.Text = "clinic not selected";
                    return;
                }
                */
                //--------------------------------------------------------
                var role = service.GetRole(ddlRoles.SelectedValueAsInt());

                if (role == null)
                {
                    lblMessage.Text = "Role not selected";
                    return;
                }

                //--------------------------------------------------------
                foreach (var item in lvUserRoles.Items)
                {
                    HiddenField hfUserInRoleId = item.RecursiveFindControl("hfUserInRoleId") as HiddenField;
                    Label lblUserName = item.RecursiveFindControl("lblUserName") as Label;
                    CheckBox chkUserInRole = item.RecursiveFindControl("chkUserInRole") as CheckBox;

                    HiddenField hfUserId = item.RecursiveFindControl("hfUserId") as HiddenField;

                    if (hfUserInRoleId != null && lblUserName != null &&
                        chkUserInRole != null && hfUserId != null)
                    {
                        int userId = 0;
                        int.TryParse(hfUserId.Value, out userId);
                        var user = service.GetUser(userId);

                        if (user == null)
                            throw new ApplicationException("User with id=" + hfUserId.Value + " not found");

                        if (chkUserInRole.Checked)
                        {
                            // a ticked check box - is user in role?
                            int userInRoleId = 0;
                            if (!int.TryParse(hfUserInRoleId.Value, out userInRoleId))
                            {
                                // user is not in role - add them
                                //user.AddRole(new UserRole() { Role = role, Site = site, Section = clinic });
                                user.AddRole(new UserRole() { Role = role });
                                service.UpdateUser(user);
                            }
                        }
                        else
                        {
                            // an unticked check box - is user in role?
                            int userInRoleId = 0;
                            if (int.TryParse(hfUserInRoleId.Value, out userInRoleId))
                            {
                                var roleToRemove = (from r in user.Roles
                                                    where r.Role.Id == role.Id
                                                    select r).FirstOrDefault();

                                if (roleToRemove != null)
                                {
                                    user.Roles.Remove(roleToRemove);
                                    service.UpdateUser(user);
                                }
                                else
                                {
                                    throw new ApplicationException("user " + user.Username + " is not in role " + role.Name + " and cannot be removed ");
                                }
                            }
                        }
                    }
                }

                _refreshData = true;

            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        protected void ddlRoles_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refreshData = true;
        }

        protected void btnCheckAll_Click(object sender, EventArgs e)
        {
            foreach (var item in lvUserRoles.Items)
            {
                CheckBox chkUserInRole = item.RecursiveFindControl("chkUserInRole") as CheckBox;

                if (chkUserInRole != null)
                {
                    chkUserInRole.Checked = true;
                }
            }
        }

        protected void btnUncheckAll_Click(object sender, EventArgs e)
        {
            foreach (var item in lvUserRoles.Items)
            {
                CheckBox chkUserInRole = item.RecursiveFindControl("chkUserInRole") as CheckBox;

                if (chkUserInRole != null)
                {
                    chkUserInRole.Checked = false;
                }
            }
        }

    }
}

/*
    <div style="background-color: #eee; padding: 10px 4px;">
                        <span style="display: inline-block; margin-right: 10px;">Site</span>
                        <asp:DropDownList ID="ddlSite" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlSite_SelectedIndexChanged"></asp:DropDownList>

                        <span style="display: inline-block; margin-left: 40px; margin-right: 10px;">Facility</span>
                        <asp:DropDownList ID="ddlFacility" AutoPostBack="true" runat="server" OnSelectedIndexChanged="ddlFacility_SelectedIndexChanged"></asp:DropDownList>

                        <span style="display: inline-block; margin-left: 40px; margin-right: 10px;">Clinic</span>
                        <asp:DropDownList ID="ddlClinic" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlClinic_SelectedIndexChanged"></asp:DropDownList>
                    </div>
 * 
 * 
 * 
 
        /// <summary>
        /// The currently selected site ID - used during a data bind
        /// </summary>
        int _siteId = 0;

        /// <summary>
        /// The currently selected clinic ID - used during a data bind
        /// </summary>
        int _cliinicId = 0;
 
 
        void LoadSites()
        {
            try
            {
                Factory factory = Helper.GetFactory(Page);
                var siteService = factory.GetSiteService();

                ddlSite.DataValueField = "Id";
                ddlSite.DataTextField = "Name";
                ddlSite.DataSource = (from s in siteService.Get()
                                      orderby s.Name
                                      select s).ToList();
                ddlSite.DataBind();

                if (ddlSite.Items.Count > 0)
                {
                    var userSession = Helper.GetUserSession(Page);

                    if (userSession != null && userSession.CurrentSite != null)
                    {
                        // select current site
                        ListItem li = ddlSite.Items.FindByValue(userSession.CurrentSite.Id.ToString());

                        if (li != null)
                        {
                            ddlSite.SelectedIndex = -1;
                            li.Selected = true;
                        }
                    }

                    // select first site when no site selected
                    if (ddlSite.SelectedIndex < 0)
                        ddlSite.SelectedIndex = 0;
                }
                else
                {
                    ddlSite.Items.Add(new ListItem("No Sites", "0"));
                }

                // we load sites only one as  it is the root - now load any facilities
                LoadFaclilities();
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        void LoadFaclilities()
        {
            try
            {
                ddlFacility.Items.Clear();

                int siteId = ddlSite.SelectedValueAsInt();

                if (siteId > 0)
                {
                    Factory factory = Helper.GetFactory(Page);
                    var faclilityService = factory.GetFacilityService();

                    ddlFacility.DataValueField = "Id";
                    ddlFacility.DataTextField = "Name";
                    ddlFacility.DataSource = (from f in faclilityService.GetAll(siteId)
                                              where f.Site.Id == siteId
                                              orderby f.Name
                                              select f).ToList();
                    ddlFacility.DataBind();
                }

                if (ddlFacility.Items.Count > 0)
                {
                    //   ddlFacility.Items.Insert(0, (new ListItem("All Facilities", "0")));
                    ddlFacility.SelectedIndex = 0;
                }
                else
                {
                    ddlFacility.Items.Add(new ListItem("No Facilities", "0"));
                }

                _refreshData = true;

                LoadClinics();
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        void LoadClinics()
        {
            try
            {
                ddlClinic.Items.Clear();

                int facilityId = ddlFacility.SelectedValueAsInt();

                if (facilityId > 0)
                {
                    Factory factory = Helper.GetFactory(Page);
                    var sectionService = factory.GetSectionService();

                    ddlClinic.DataValueField = "Id";
                    ddlClinic.DataTextField = "Name";
                    ddlClinic.DataSource = (from c in sectionService.GetAll(facilityId)
                                            where c.Facility.Id == facilityId
                                            orderby c.Name
                                            select c).ToList();
                    ddlClinic.DataBind();
                }

                if (ddlClinic.Items.Count > 0)
                {
                    //ddlClinic.Items.Insert(0, (new ListItem("All Clinics", "0")));
                    ddlClinic.SelectedIndex = 0;
                }
                else
                {
                    ddlClinic.Items.Add(new ListItem("No Clinics", "0"));
                }

                _refreshData = true;
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

  
        protected void ddlSite_SelectedIndexChanged(object sender, EventArgs e)
        {
            LoadFaclilities();
        }

        protected void ddlFacility_SelectedIndexChanged(object sender, EventArgs e)
        {
            LoadClinics();
        }

        protected void ddlClinic_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refreshData = true;
        }
*/