﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="Users.aspx.cs" Inherits="BT.Health.SchedulingWeb.Administration.Users.Users" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <h1>Users</h1>
            <div style="height: 20px;">
                <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
            </div>
            <div style="height: 20px;">
                <asp:UpdateProgress ID="UpdateProgressPatientSearch" runat="server" DisplayAfter="0">
                    <ProgressTemplate>
                        <span style="color: #a49d1a;">Loading</span>&nbsp;<img src="/graphics/loading.gif" alt="loading data" title="loading data" />
                    </ProgressTemplate>
                </asp:UpdateProgress>
            </div>
            <div style="width: 500px; margin: 0 auto;">
                <asp:MultiView ID="mv" runat="server" ActiveViewIndex="0">
                    <asp:View ID="viewUserList" runat="server">
                        <table style="margin-bottom: 4px; width: 100%;">
                            <tr valign="middle">
                                <td>
                                    <asp:Button ID="btnShowAddUser" runat="server" Text="Add User" OnClick="btnShowAddUser_Click" />
                                </td>
                                <td style="text-align: right">Administrator&nbsp;
                                <asp:Image ID="Image1" ImageUrl="~/Graphics/user.png" ToolTip="Admin user icon" AlternateText="Admin user icon" runat="server" /></td>
                            </tr>
                        </table>
                        <asp:ListView ID="lvUsers" runat="server" OnItemCommand="lvUsers_ItemCommand" OnItemDataBound="lvUsers_ItemDataBound">
                            <EmptyDataTemplate>No Users</EmptyDataTemplate>
                            <ItemTemplate>
                                <tr class="gridViewRowStyle" valign="middle">
                                    <td style="width: 200px;">
                                        <asp:Image ID="imgAdmin" runat="server" />
                                        <asp:LinkButton ID="lbUser" runat="server"></asp:LinkButton>
                                        <asp:Label ID="lblAdminUser" runat="server"></asp:Label>
                                    </td>
                                    <td style="width: 150px;">
                                        <asp:LinkButton ID="lbChangePassword" runat="server" Text="Change Password" CssClass="linkWIthSmallSpace"></asp:LinkButton>
                                        <asp:LinkButton ID="lbViewRoles" runat="server" Text="View Roles" CssClass="linkWIthSmallSpace"></asp:LinkButton>
                                        <asp:LinkButton ID="lbDeleteUser" runat="server" Text="Delete User" CssClass="linkWIthSmallSpace" OnClientClick="return confirm('Confirm that you want to delete this user');"></asp:LinkButton>
                                    </td>
                                </tr>
                            </ItemTemplate>
                            <AlternatingItemTemplate>
                                <tr class="gridViewAlternatingRowStyle" valign="middle">
                                    <td style="width: 200px;">
                                        <asp:Image ID="imgAdmin" runat="server" />
                                        <asp:LinkButton ID="lbUser" runat="server"></asp:LinkButton>
                                        <asp:Label ID="lblAdminUser" runat="server"></asp:Label>
                                    </td>
                                    <td style="width: 150px;">
                                        <asp:LinkButton ID="lbChangePassword" runat="server" Text="Change Password" CssClass="linkWIthSmallSpace"></asp:LinkButton>
                                        <asp:LinkButton ID="lbViewRoles" runat="server" Text="View Roles" CssClass="linkWIthSmallSpace"></asp:LinkButton>
                                        <asp:LinkButton ID="lbDeleteUser" runat="server" Text="Delete User" CssClass="linkWIthSmallSpace" OnClientClick="return confirm('Confirm that you want to delete this user');"></asp:LinkButton>
                                    </td>
                                </tr>
                            </AlternatingItemTemplate>
                            <LayoutTemplate>
                                <table class="gridView" style="width: 100%; margin: 0 auto;">
                                    <thead>
                                        <tr>
                                            <th style="width: 200px;">User Name</th>
                                            <th style="width: 150px;">Manage User</th>
                                        </tr>
                                    </thead>
                                </table>
                                <div style="max-height: 500px; overflow: auto; border: 2px solid gray;">
                                    <table class="gridView" style="width: 100%; margin: 0 auto; border: none;">
                                        <tbody>
                                            <tr runat="server" id="itemPlaceholder"></tr>
                                        </tbody>
                                    </table>
                                </div>
                            </LayoutTemplate>
                        </asp:ListView>
                    </asp:View>
                    <asp:View ID="viewAddditUser" runat="server">
                        <asp:HiddenField ID="hfEditUserId" runat="server" />
                        <h2>
                            <asp:Label ID="lblAddEdit" runat="server" Text="Add User"></asp:Label></h2>
                        <table cellpadding="10">
                            <tr>
                                <td>User Name</td>
                                <td>
                                    <asp:TextBox ID="tbUserName" runat="server" MaxLength="32"></asp:TextBox></td>
                            </tr>
                            <tr runat="server" id="trPassword">
                                <td>Password</td>
                                <td>
                                    <asp:TextBox ID="tbPassword" runat="server" MaxLength="32"></asp:TextBox></td>
                            </tr>
                            <tr>
                                <td>First Name</td>
                                <td>
                                    <asp:TextBox ID="tbFirstName" runat="server" MaxLength="32"></asp:TextBox>

                                </td>
                            </tr>
                            <tr>
                                <td>Last Name</td>
                                <td>
                                    <asp:TextBox ID="tbLastName" runat="server" MaxLength="32"></asp:TextBox></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: right;">
                                    <asp:Button ID="btnCancel" runat="server" Text="Cancel" OnClick="btnCancel_Click" />&nbsp;
                                    <asp:Button ID="btnSave" runat="server" Text="Save" OnClick="btnSave_Click" />
                                </td>
                            </tr>
                        </table>
                    </asp:View>
                    <asp:View ID="viewChangePassword" runat="server">
                        <h2>Change Password</h2>
                        <table cellpadding="10">
                            <tr>
                                <td>New Password</td>
                                <td>
                                    <asp:TextBox ID="tbChangedPassword" runat="server" MaxLength="32"></asp:TextBox></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: right;">
                                    <asp:Button ID="btnCancelChangePassword" runat="server" Text="Cancel" OnClick="btnCancel_Click" />&nbsp;
                                    <asp:Button ID="btnSaveNewPassword" runat="server" Text="Save" OnClick="btnSaveNewPassword_Click" />
                                </td>
                            </tr>
                        </table>
                    </asp:View>
                </asp:MultiView>
            </div>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
