﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using MedRed.Services;
using MedRed.Services.Interfaces;
using Shared.Model.Config.MDWS;
using Shared.Model;
using Shared.Model.UserRoles;
using BT.Health.SchedulingWeb.UISession;

namespace BT.Health.SchedulingWeb.Administration.Users
{
    public partial class Roles : System.Web.UI.Page
    {
        bool _refreshData = false;

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                _refreshData = true;
            }
        }

        protected void Page_PreRender(object sender, EventArgs e)
        {
            if (_refreshData)
            {
                LoadData();
            }
        }

        void LoadData()
        {
            try
            {
                Factory factory = Helper.GetFactory(Page);
                var service = factory.GetAccountService();

                lvRoles.DataSource = (from r in service.GetAllRoles()
                                      orderby r.Name
                                      select r).ToList();

                lvRoles.DataBind();
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }


        protected void lvRoles_ItemDataBound(object sender, ListViewItemEventArgs e)
        {
            if (e.Item.ItemType == ListViewItemType.DataItem)
            {
                Role role = e.Item.DataItem as Role;
                Image imgAdmin = e.Item.RecursiveFindControl("imgAdmin") as Image;
                LinkButton lbRoleEdit = e.Item.RecursiveFindControl("lbRoleEdit") as LinkButton;
                Label lblRoleAdmin = e.Item.RecursiveFindControl("lblRoleAdmin") as Label;

                LinkButton lbViewUsersInRole = e.Item.RecursiveFindControl("lbViewUsersInRole") as LinkButton;
                LinkButton lbDeleteRole = e.Item.RecursiveFindControl("lbDeleteRole") as LinkButton;

                if (role != null && imgAdmin != null && lbRoleEdit != null &&
                    lblRoleAdmin != null && lbViewUsersInRole != null && lbDeleteRole != null)
                {
                    string commandArgument = role.Id.ToString();

                    lbViewUsersInRole.CommandName = "ViewUsersInRole";
                    lbViewUsersInRole.CommandArgument = commandArgument;

                    if (role.Name == "Administrator")
                    {
                        // show controls and state for admin rolw - can't edit
                        imgAdmin.ImageUrl = "~/graphics/user.png";
                        imgAdmin.ToolTip = "Administrator Role";
                        imgAdmin.AlternateText = imgAdmin.ToolTip;

                        lbRoleEdit.Visible = false;

                        lblRoleAdmin.Visible = true;
                        lblRoleAdmin.Text = role.Name;

                        lbDeleteRole.Visible = false;
                        lbViewUsersInRole.Visible = false;
                    }
                    else
                    {
                        // show all other roles except admin
                        imgAdmin.ImageUrl = "~/graphics/empty.png";
                        imgAdmin.AlternateText = "Standard role";
                        imgAdmin.AlternateText = imgAdmin.ToolTip;

                        lbRoleEdit.Visible = true;
                        lbRoleEdit.Text = role.Name;
                        lbRoleEdit.CommandName = "EditRole";
                        lbRoleEdit.CommandArgument = commandArgument;

                        lblRoleAdmin.Visible = false;

                        lbDeleteRole.CommandName = "DeleteRole";
                        lbDeleteRole.CommandArgument = commandArgument;
                        lbDeleteRole.Visible = true;
                    }
                }
            }
        }

        protected void lvRoles_ItemCommand(object sender, ListViewCommandEventArgs e)
        {
            int id = 0;
            int.TryParse(e.CommandArgument.ToString(), out id);

            switch (e.CommandName)
            {
                case "EditRole":
                    EditRole(id);
                    break;

                case "ViewUsersInRole":
                    Response.Redirect("~/Administration/Users/UsersInRoles.aspx?roleid=" + id.ToString(), false);
                    break;

                case "DeleteRole":
                    DeleteRole(id);
                    break;
            }
        }

        void DeleteRole(int roleId)
        {
            try
            {
                if (roleId > 0)
                {
                    Factory factory = Helper.GetFactory(Page);
                    var service = factory.GetAccountService();

                    var role = service.GetRole(roleId);

                    if (role != null)
                    {
                        string roleName = role.Name;
                        service.DeleteRole(role.Id);
                        lblMessage.Text = "Role [" + roleName + "] deleted";

                        mv.ActiveViewIndex = 0;
                        _refreshData = true;
                    }
                    else
                    {
                        lblMessage.Text = "Role not found";
                    }
                }
                else
                {
                    lblMessage.Text = "Role not specified";
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        void EditRole(int roleId)
        {
            try
            {
                if (roleId > 0)
                {
                    Factory factory = Helper.GetFactory(Page);
                    var service = factory.GetAccountService();

                    var role = service.GetRole(roleId);

                    if (role != null)
                    {
                        lblAddEdit.Text = "Edit Role";
                        tbRoleName.Text = role.Name;
                        RoleEditId = role.Id;
                        mv.ActiveViewIndex = 1;
                        tbRoleName.Focus();
                    }
                    else
                    {
                        lblMessage.Text = "Role not found";
                    }
                }
                else
                {
                    lblMessage.Text = "Role not specified";
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        void SaveNewRole()
        {
            try
            {
                string roleNameNew = tbRoleName.Text.Trim();

                if (roleNameNew.Length == 0)
                {
                    lblMessage.Text = "Role name cannot be empty";
                    return;
                }

                Factory factory = Factory.GetFactory(MDWSConfiguration_ConfigHelper.GetDefaultConfig());
                var service = factory.GetAccountService();

                var existingName = (from r in service.GetAllRoles()
                                    where r.Name == roleNameNew
                                    select r).FirstOrDefault();

                if (existingName != null)
                {
                    lblMessage.Text = "This role name is already used";
                    return;
                }

                Shared.Model.UserRoles.Role roleNew = new Shared.Model.UserRoles.Role();
                roleNew.Name = roleNameNew;

                service.AddRole(roleNew);
                lblMessage.Text = "Role [" + roleNew.Name + "] " + " Added";
                mv.ActiveViewIndex = 0;
                _refreshData = true;
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        void SaveExistingRole(int id)
        {
            try
            {
                string roleNameTrimmed = tbRoleName.Text.Trim();

                if (roleNameTrimmed.Length == 0)
                {
                    lblMessage.Text = "Role name cannot be empty";
                    return;
                }

                Factory factory = Factory.GetFactory(MDWSConfiguration_ConfigHelper.GetDefaultConfig());
                var service = factory.GetAccountService();

                // get names for all but the editing role
                var existingName = (from r in service.GetAllRoles()
                                    where r.Id != id &&
                                    r.Name == roleNameTrimmed
                                    select r).FirstOrDefault();

                if (existingName != null)
                {
                    lblMessage.Text = "This role name is already used";
                    return;
                }

                var role = service.GetRole(id);

                if (role != null)
                {
                    string oldName = role.Name;
                    role.Name = roleNameTrimmed;
                    service.UpdateRole(role);

                    lblMessage.Text = "[" + oldName + "] renamed to [" + role.Name + "] ";
                    mv.ActiveViewIndex = 0;
                    _refreshData = true;
                }
                else
                {
                    lblMessage.Text = "Cannot find role";
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }


        protected void lbSaveRole_Click(object sender, EventArgs e)
        {
            int roleId = RoleEditId;

            if (roleId > 0)
                SaveExistingRole(roleId);
            else
                SaveNewRole();
        }

        /// <summary>
        /// Gets or sets the role ID in edit
        /// Zero when adding a new role
        /// </summary>
        int RoleEditId
        {
            get
            {
                int id = 0;
                int.TryParse(hfEditId.Value, out id);
                return id;
            }

            set
            {
                hfEditId.Value = value.ToString();
            }
        }

        protected void btnAddRole_Click(object sender, EventArgs e)
        {
            lblAddEdit.Text = "Add Role";
            tbRoleName.Text = string.Empty;
            RoleEditId = 0;
            mv.ActiveViewIndex = 1;
            tbRoleName.Focus();
        }

        protected void lbCancelAddRole_Click(object sender, EventArgs e)
        {
            mv.ActiveViewIndex = 0;
        }
    }
}