﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="Roles.aspx.cs" Inherits="BT.Health.SchedulingWeb.Administration.Users.Roles" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <h1>Roles</h1>
            <div style="height: 20px;">
                <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
            </div>
            <div style="height: 20px;">
                <asp:UpdateProgress ID="UpdateProgressPatientSearch" runat="server" DisplayAfter="0">
                    <ProgressTemplate>
                        <span style="color: #a49d1a;">Loading</span>&nbsp;<img src="/graphics/loading.gif" alt="loading data" title="loading data" />
                    </ProgressTemplate>
                </asp:UpdateProgress>
            </div>
            <div style="width: 500px; margin: 0 auto;">
                <asp:HiddenField ID="hfEditId" runat="server" />
                <asp:MultiView ID="mv" runat="server" ActiveViewIndex="0">
                    <asp:View ID="viewRolesList" runat="server">
                        <table style="margin-bottom: 4px; width: 100%;">
                            <tr valign="middle">
                                <td>
                                    <asp:Button ID="btnAddRole" runat="server" Text="Add Role" OnClick="btnAddRole_Click" />
                                </td>
                                <td style="text-align: right">Administrator&nbsp;
                                <asp:Image ID="Image1" ImageUrl="~/Graphics/user.png" ToolTip="Admin user icon" AlternateText="Admin user icon" runat="server" /></td>
                            </tr>
                        </table>
                        <asp:ListView ID="lvRoles" runat="server" OnItemCommand="lvRoles_ItemCommand" OnItemDataBound="lvRoles_ItemDataBound">
                            <EmptyDataTemplate>No Roles</EmptyDataTemplate>
                            <ItemTemplate>
                                <tr class="gridViewRowStyle">
                                    <td>
                                        <asp:Image ID="imgAdmin" runat="server" />
                                        <asp:LinkButton ID="lbRoleEdit" runat="server"></asp:LinkButton>
                                        <asp:Label ID="lblRoleAdmin" runat="server"></asp:Label>
                                    </td>
                                    <td>
                                        <asp:LinkButton ID="lbViewUsersInRole" runat="server" Text="Users in role" CssClass="linkWIthSmallSpace"></asp:LinkButton>
                                        <asp:LinkButton ID="lbDeleteRole" runat="server" Text="Delete role" CssClass="linkWIthSmallSpace" OnClientClick="return confirm('Confirm that you want to delete this role');"></asp:LinkButton>
                                    </td>
                                </tr>
                            </ItemTemplate>
                            <AlternatingItemTemplate>
                                <tr class="gridViewAlternatingRowStyle">
                                    <td>
                                        <asp:Image ID="imgAdmin" runat="server" />
                                        <asp:LinkButton ID="lbRoleEdit" runat="server"></asp:LinkButton>
                                        <asp:Label ID="lblRoleAdmin" runat="server"></asp:Label>
                                    </td>
                                    <td>
                                        <asp:LinkButton ID="lbViewUsersInRole" runat="server" Text="View users in role" CssClass="linkWIthSmallSpace"></asp:LinkButton>
                                        <asp:LinkButton ID="lbDeleteRole" runat="server" Text="Delete role" CssClass="linkWIthSmallSpace" OnClientClick="return confirm('Confirm that you want to delete this role');"></asp:LinkButton>
                                    </td>
                                </tr>
                            </AlternatingItemTemplate>
                            <LayoutTemplate>
                                <table class="gridView" style="width: 100%; margin: 0 auto;">
                                    <thead>
                                        <tr>
                                            <th style="width: 200px;">Role Name</th>
                                            <th style="width: 150px;">Manage Role</th>
                                        </tr>
                                    </thead>
                                </table>
                                <div style="max-height: 500px; overflow: auto; border: 2px solid gray;">
                                    <table class="gridView" style="width: 100%; margin: 0 auto; border: none;">
                                        <tbody>
                                            <tr runat="server" id="itemPlaceholder"></tr>
                                        </tbody>
                                    </table>
                            </LayoutTemplate>
                        </asp:ListView>
                    </asp:View>
                    <asp:View ID="viewAddEditRole" runat="server">
                               <h2>
                            <asp:Label ID="lblAddEdit" runat="server" Text="Add Role"></asp:Label></h2>
                        <table style="margin-left: 50px;">
                            <tr>
                                <td>Role&nbsp;Name</td>
                                <td>
                                    <asp:TextBox ID="tbRoleName" runat="server" MaxLength="32"></asp:TextBox></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: right;">
                                    <asp:LinkButton ID="lbCancelAddRole" runat="server" CssClass="linkAsButton" OnClick="lbCancelAddRole_Click">Cancel</asp:LinkButton>&nbsp;
                                    <asp:LinkButton ID="lbSaveRole" runat="server" CssClass="linkAsButton" OnClick="lbSaveRole_Click">Save</asp:LinkButton>
                                </td>
                            </tr>
                        </table>
                    </asp:View>
                </asp:MultiView>
            </div>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
