﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using MedRed.Services;
using MedRed.Services.Interfaces;
using Shared.Model.Config.MDWS;
using Shared.Model;
using Shared.Model.UserRoles;
using BT.Health.SchedulingWeb.UISession;

namespace BT.Health.SchedulingWeb.Administration.Users
{
    public partial class RoleActions : System.Web.UI.Page
    {
        // the rolefor which actions are being edited during the current databind
        Shared.Model.UserRoles.Role _roleSelected = null;

        /// <summary>
        /// true to refresh list of users
        /// </summary>
        bool _refreshData = false;

        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                lblMessage.Text = string.Empty;

                if (!IsPostBack)
                {
                    LoadRolesDdl();
                    _refreshData = true;
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        protected void Page_PreRender(object sender, EventArgs e)
        {
            try
            {
                if (_refreshData)
                {
                    LoadData();
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        void LoadRolesDdl()
        {
            try
            {
                Factory factory = Helper.GetFactory(Page);
                var service = factory.GetAccountService();

                // show all but the admin role
                ddlRoles.DataSource = (from r in service.GetAllRoles()
                                       where r.Name != "Administrator"
                                       orderby r.Name
                                       select r).ToList();

                ddlRoles.DataValueField = "Id";
                ddlRoles.DataTextField = "Name";
                ddlRoles.DataBind();

                if (ddlRoles.Items.Count > 0)
                {
                    ddlRoles.SelectedIndex = 0;
                }
                else
                {
                    ddlRoles.Items.Add(new ListItem("No roles", "0"));
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        void LoadData()
        {
            try
            {
                Factory factory = Helper.GetFactory(Page);
                var service = factory.GetAccountService();

                _roleSelected = service.GetRole(ddlRoles.SelectedValueAsInt());

                if (_roleSelected != null)
                {
                    lv.DataSource = (from a in service.GetAllActions()
                                     orderby a.Name
                                     select a).ToList();
                }
                else
                {
                    lv.DataSource = null;
                }

                lv.DataBind();
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        protected void lv_ItemDataBound(object sender, ListViewItemEventArgs e)
        {
            if (e.Item.ItemType == ListViewItemType.DataItem)
            {
                Shared.Model.UserRoles.Action action = e.Item.DataItem as Shared.Model.UserRoles.Action;
                HiddenField hfActionId = e.Item.RecursiveFindControl("hfActionId") as HiddenField;
                CheckBox chkRoleHasAction = e.Item.RecursiveFindControl("chkRoleHasAction") as CheckBox;
                Label lblActionName = e.Item.RecursiveFindControl("lblActionName") as Label;

                if (action != null && hfActionId != null && chkRoleHasAction != null && lblActionName != null)
                {
                    chkRoleHasAction.Text = action.Name;
                    lblActionName.Text = "(" + action.Key + ")";
                    lblActionName.ToolTip = action.Description;

                    chkRoleHasAction.Checked = ((from r in _roleSelected.Actions
                                                 where r.Id == action.Id
                                                 select r).FirstOrDefault() != null);

                    hfActionId.Value = action.Id.ToString();
                }
            }
        }

        protected void btnSaveChanges_Click(object sender, EventArgs e)
        {
            try
            {
                Factory factory = Helper.GetFactory(Page);
                var service = factory.GetAccountService();

                //--------------------------------------------------------
                var role = service.GetRole(ddlRoles.SelectedValueAsInt());

                if (role == null)
                {
                    lblMessage.Text = "Role not selected";
                    return;
                }

                var actions = (from a in service.GetAllActions()
                               select a).ToList();

                //--------------------------------------------------------
                int added = 0;
                int removed = 0;

                foreach (var item in lv.Items)
                {
                    HiddenField hfActionId = item.RecursiveFindControl("hfActionId") as HiddenField;
                    CheckBox chkRoleHasAction = item.RecursiveFindControl("chkRoleHasAction") as CheckBox;

                    if (hfActionId != null && chkRoleHasAction != null)
                    {
                        int actionId = int.Parse(hfActionId.Value);

                        var action = (from a in actions
                                      where a.Id == actionId
                                      select a).FirstOrDefault();

                        if (action == null)
                            throw new ApplicationException("Action with id=" + hfActionId.Value + " not found");

                        var actionInRole = (from a in role.Actions
                                            where a.Id == action.Id
                                            select a).FirstOrDefault();

                        if (chkRoleHasAction.Checked)
                        {
                            // a ticked check box - is action in role?
                            if (actionInRole == null)
                            {
                                // add action to role
                                role.Actions.Add(action);
                                service.UpdateRole(role);
                                added += 1;
                            }
                        }
                        else
                        {
                            if (actionInRole != null)
                            {
                                // an unticked check box - remove action to role
                                var actionToRemove = (from a in role.Actions
                                                      where a.Id == action.Id
                                                      select a).FirstOrDefault();

                                if (actionToRemove != null)
                                {
                                    role.Actions.Remove(actionToRemove);
                                    service.UpdateRole(role);
                                    removed += 1;
                                }
                            }
                        }
                    }
                }

                lblMessage.Text = "Added:" + added.ToString() + ", Removed:" + removed.ToString();
                _refreshData = true;

            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        protected void ddlRoles_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refreshData = true;
        }

        protected void btnCheckAll_Click(object sender, EventArgs e)
        {
            foreach (var item in lv.Items)
            {
                CheckBox chkRoleHasAction = item.RecursiveFindControl("chkRoleHasAction") as CheckBox;

                if (chkRoleHasAction != null)
                {
                    chkRoleHasAction.Checked = true;
                }
            }
        }

        protected void btnUncheckAll_Click(object sender, EventArgs e)
        {
            foreach (var item in lv.Items)
            {
                CheckBox chkRoleHasAction = item.RecursiveFindControl("chkRoleHasAction") as CheckBox;

                if (chkRoleHasAction != null)
                {
                    chkRoleHasAction.Checked = false;
                }
            }
        }
    }
}