﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="RoleActions.aspx.cs" Inherits="BT.Health.SchedulingWeb.Administration.Users.RoleActions" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <h1>Users In Roles</h1>
            <div style="height: 20px;">
                <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
            </div>
            <div style="height: 20px;">
                <asp:UpdateProgress ID="UpdateProgressPatientSearch" runat="server" DisplayAfter="0">
                    <ProgressTemplate>
                        <span style="color: #a49d1a;">Loading</span>&nbsp;<img src="/graphics/loading.gif" alt="loading data" title="loading data" />
                    </ProgressTemplate>
                </asp:UpdateProgress>
            </div>

            <div style="width: 500px; margin: 0 auto;">
                <table style="margin-bottom: 10px; width: 100%;">
                    <tr valign="middle">
                        <td>Role&nbsp;<asp:DropDownList ID="ddlRoles" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlRoles_SelectedIndexChanged"></asp:DropDownList>
                            &nbsp;<asp:Button ID="btnCheckAll" runat="server" Text="Check All" OnClick="btnCheckAll_Click" />
                            &nbsp;<asp:Button ID="btnUncheckAll" runat="server" Text="Uncheck All" OnClick="btnUncheckAll_Click" />

                        </td>
                        <td style="text-align: right;">
                            <asp:Button ID="btnSaveChanges" runat="server" Text="Save" OnClick="btnSaveChanges_Click" /></td>
                    </tr>
                </table>
                <asp:ListView ID="lv" runat="server" OnItemDataBound="lv_ItemDataBound">
                    <EmptyDataTemplate>A role is not selected</EmptyDataTemplate>
                    <ItemTemplate>
                        <tr class="gridViewRowStyle">
                            <td>
                                <asp:HiddenField ID="hfActionId" runat="server" />
                                <asp:CheckBox ID="chkRoleHasAction" runat="server" />&nbsp;
                                <asp:Label ID="lblActionName" runat="server"></asp:Label>
                            </td>
                        </tr>
                    </ItemTemplate>
                    <AlternatingItemTemplate>
                        <tr class="gridViewAlternatingRowStyle">
                            <td>
                                <asp:HiddenField ID="hfActionId" runat="server" />
                                <asp:CheckBox ID="chkRoleHasAction" runat="server" />&nbsp;
                                <asp:Label ID="lblActionName" runat="server"></asp:Label>
                            </td>
                        </tr>
                    </AlternatingItemTemplate>
                    <LayoutTemplate>
                        <table class="gridView" style="width: 100%; margin: 0 auto;">
                            <thead>
                                <tr>
                                    <td>Role has Action</td>
                                </tr>
                            </thead>
                            <tbody>
                                <tr runat="server" id="itemPlaceholder"></tr>
                            </tbody>
                        </table>
                    </LayoutTemplate>
                </asp:ListView>
            </div>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
