﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using MedRed.Services;
using MedRed.Services.Interfaces;
using Shared.Model.Config.MDWS;
using Shared.Model;
using Shared.Model.UserRoles;
using BT.Health.SchedulingWeb.UISession;

namespace BT.Health.SchedulingWeb.Administration.Users
{
    public partial class Actions : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                LoadData();
            }
        }

        void LoadData()
        {
            try
            {
                Factory factory = Helper.GetFactory(Page);

                var service = factory.GetAccountService();

                lvActions.DataSource = (from a in service.GetAllActions()
                                        orderby a.Name
                                        select a).ToList();

                lvActions.DataBind();
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }
    }
}