﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.IO;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;


namespace BT.Health.SchedulingWeb.Administration.Templates
{
    public partial class TemplateUpload : System.Web.UI.Page
    {
        public int _parentID = 0;
        public int _itemID = 0;
        public bool _parentIsFacility = true;

        protected void Page_Load(object sender, EventArgs e)
        {
            lblMessage.Text = string.Empty;

            btnExtract.Visible = false;

            _parentID = Helper.GetQueryStringInt(Request.QueryString["id"]);
            _itemID = Helper.GetQueryStringInt(Request.QueryString["itemid"]);
            _parentIsFacility = Helper.GetQueryString(Request.QueryString["facility"]) == "Y";

            if (!IsPostBack)
            {
                TemplateTypeList.Items.Add(new ListItem("Pre Appointment", "PreAppointment"));
                TemplateTypeList.Items.Add(new ListItem("Post Appointment", "PostAppointment"));
                TemplateTypeList.Items.Add(new ListItem("Cancellation", "Cancellation"));
                TemplateTypeList.Items.Add(new ListItem("Transfer", "Transfer"));
                TemplateTypeList.Items.Add(new ListItem("Waiting List", "WaitingList"));

                if (_itemID != 0)
                {
                    Factory factory = Helper.GetFactory(Page);
                    CommunicationTemplate ct = null;

                    if (_parentIsFacility)
                    {
                        MedRed.Services.Interfaces.IFacilityService ifs = factory.GetFacilityService();
                        Facility f = ifs.Get(_parentID);

                        // get the template where the id's match

                        ct = f.CommunicationTemplates.Single(p => p.Id == _itemID);
                    }
                    else
                    {
                        MedRed.Services.Interfaces.ISectionService iss = factory.GetSectionService();
                        Section s = iss.Get(_parentID);

                        // get the template where the id's match

                        ct = s.CommunicationTemplates.Single(p => p.Id == _itemID);
                    }

                    if (!(ct.Message == null || ct.Message.Length == 0))
                    {
                        btnExtract.Visible = true;
                    }

                    // hfFileName = ct.
                    TemplateName.Text = ct.Name;
                    TemplateSubject.Text = ct.Subject;
                    TemplateName.Enabled = false;
                    foreach (ListItem li in TemplateTypeList.Items)
                    {
                        if (li.Value == ct.Type.ToString())
                        {
                            li.Selected = true;
                            TemplateTypeList.SelectedIndex = TemplateTypeList.Items.IndexOf(li);
                            break;
                        }
                    }

                    foreach (ListItem li in drpMedium.Items)
                    {
                        if (li.Value == ct.Medium)
                        {
                            li.Selected = true;
                            drpMedium.SelectedIndex = drpMedium.Items.IndexOf(li);
                            break;
                        }
                    }

                    foreach (ListItem li in drpRecipient.Items)
                    {
                        if (li.Value == ct.Recipient)
                        {
                            li.Selected = true;
                            drpRecipient.SelectedIndex = drpRecipient.Items.IndexOf(li);
                            break;
                        }
                    }
                }
            }
        }

        protected void btnExtract_Click(object sender, EventArgs e)
        {
            if (_itemID != 0)
            {
                Factory factory = Helper.GetFactory(Page);
                CommunicationTemplate ct = null;

                if (_parentIsFacility)
                {
                    MedRed.Services.Interfaces.IFacilityService ifs = factory.GetFacilityService();
                    Facility f = ifs.Get(_parentID);

                    // get the template where the id's match

                    ct = f.CommunicationTemplates.Single(p => p.Id == _itemID);
                }
                else
                {
                    MedRed.Services.Interfaces.ISectionService iss = factory.GetSectionService();
                    Section s = iss.Get(_parentID);

                    // get the template where the id's match

                    ct = s.CommunicationTemplates.Single(p => p.Id == _itemID);
                }

                if (!(ct.Message == null || ct.Message.Length == 0))
                {
                    DownloadFile(ct);
                }
            }
            else
            {

            }
        }

        private void DownloadFile(CommunicationTemplate ct)
        {
            Response.AppendHeader("content-disposition", "attachment; filename=" + ct.Name + ".txt");
            Response.ContentType = "text/plain";
            Response.Write(ct.Message);
            Response.End();
        }


        protected void btnUpload_Click(object sender, EventArgs e)
        {
            CommunicationTemplate ct = new CommunicationTemplate();
            ct.Name = TemplateName.Text;
            ct.Subject = TemplateSubject.Text;
            ct.Message = "";
            ct.Type = (CommunicationType)Enum.Parse(typeof(CommunicationType), TemplateTypeList.SelectedItem.Value);
            ct.Recipient = drpRecipient.SelectedItem.Value;
            ct.Medium = drpMedium.SelectedItem.Value;

            if ((FileUpload1.PostedFile != null) && (FileUpload1.PostedFile.ContentLength > 0))
            {
                using (StreamReader reader = new StreamReader(FileUpload1.FileContent))
                {
                    ct.Message = reader.ReadToEnd();
                }
            }
            else
            {
                lblMessage.Text = "Please select a file to upload";
                return;
            }

            UserSession userSession = Helper.GetUserSession(Page);

            if (userSession != null)
            {
                Factory factory = Helper.GetFactory(Page);

                // upload comm template to facility
                if (_parentIsFacility)
                {
                    MedRed.Services.Interfaces.IFacilityService ifs = factory.GetFacilityService();
                    Facility f = ifs.Get(_parentID);

                    CommunicationTemplate ctCurrent = f.CommunicationTemplates.FirstOrDefault(p => p.Id == _itemID);

                    // if we have not added a new template message, get the original one
                    if (ctCurrent != null)
                    {
                        if (ct.Message == null || ct.Message == "")
                        {
                            ct.Message = ctCurrent.Message;
                        }
                        ct.Id = ctCurrent.Id;

                    }
                    ifs.AddOrUpdateCommunicationTemplate(f.Id, ct);

                }
                else
                {
                    MedRed.Services.Interfaces.ISectionService iss = factory.GetSectionService();
                    Section s = iss.Get(_parentID);
                    CommunicationTemplate ctCurrent = s.CommunicationTemplates.FirstOrDefault(p => p.Id == _itemID);

                    // if we have not added a new template message, get the original one
                    if (ctCurrent != null)
                    {
                        if (ct.Message == null || ct.Message == "")
                        {
                            ct.Message = ctCurrent.Message;
                        }
                        ct.Id = ctCurrent.Id;
                    }
                    iss.AddOrUpdateCommunicationTemplate(s.Id, ct);
                }
                string reply = "N";
                if (_parentIsFacility)
                    reply = "Y";
                Response.Redirect("TemplateList.aspx?" + "facility=" + reply + "&id=" + _parentID.ToString());

            }
        }



    }
}