﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;

using System.Linq;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration
{
    public partial class TemplateList : System.Web.UI.Page
    {
        public int _parentID = 0;
        public bool _parentIsFacility=true;
        
        protected void Page_Load(object sender, EventArgs e)
        {
            _parentID = Helper.GetQueryStringInt(Request.QueryString["id"]);
            _parentIsFacility = Helper.GetQueryString(Request.QueryString["facility"])=="Y";
            AddTemplateLink.NavigateUrl = "~/Administration/Templates/TemplateUpload.aspx?itemid=0&facility=" + Helper.GetQueryString(Request.QueryString["facility"]) + "&id=" + _parentID.ToString();
        }

        public DataTable GetTemplatesList(string id, string facility)
        {
            DataTable dt = new DataTable("CommunicationTemplate");
            dt.Columns.Add("id");
            dt.Columns.Add("Name");
            dt.Columns.Add("Subject");
            dt.Columns.Add("Medium");
            dt.Columns.Add("Recipient");
            dt.Columns.Add("Type");
            dt.Columns.Add("Facility");
            dt.Columns.Add("ParentId");
            try
            {
                UserSession userSession = Helper.GetUserSession(Page);
                Factory factory = Helper.GetFactory(Page);
                IList<CommunicationTemplate> templateList = null;

                if (facility == "Y")
                {
                    MedRed.Services.Interfaces.IFacilityService facilityService = factory.GetFacilityService();
                    Facility f = facilityService.Get(Convert.ToInt32(id));
                    templateList = f.CommunicationTemplates;

                }
                else
                {
                    MedRed.Services.Interfaces.ISectionService sectionService = factory.GetSectionService();
                    Section s = sectionService.Get(Convert.ToInt32(id));
                    templateList = s.CommunicationTemplates;
                }

                foreach (CommunicationTemplate ct in templateList)
                {
                    dt.Rows.Add(ct.Id, ct.Name, ct.Subject, ct.Medium, ct.Recipient, ct.Type.ToString(), facility, id);
                }

            }
            catch (Exception e)
            {
                //Logging here
            }
            return dt;
        }
    }
}