﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;
using System.Collections.ObjectModel;

namespace BT.Health.SchedulingWeb.Administration
{
    public partial class SiteList : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }


        public Collection<Site> GetSiteList()
        {
            UserSession userSession = Helper.GetUserSession(Page);

            Factory factory = Helper.GetFactory(Page);

            MedRed.Services.Interfaces.ISiteService siteService = factory.GetSiteService();
         
            Collection<Site> facilityList = siteService.Get();
            Facility f = new Facility();
          
            return facilityList; ;
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Shared.Model.Site s = e.Row.DataItem as Shared.Model.Site;

                if (s != null && s.TimeZoneId != null)
                {
                    e.Row.Cells[4].Text = TimeZoneInfo.FindSystemTimeZoneById(s.TimeZoneId).DisplayName;
                }
            }
        }
    }

   
}