﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration.Schedules
{
    public partial class SlotList : System.Web.UI.Page
    {
        public int _resourceId = 0;
        public int _policyId = 0;
        public int _sectionid = 0;

        protected void Page_Load(object sender, EventArgs e)
        {
            _policyId = Helper.GetQueryStringInt(Request.QueryString["policyid"]);
            _sectionid = Helper.GetQueryStringInt(Request.QueryString["sectionid"]);
            _resourceId = Helper.GetQueryStringInt(Request.QueryString["resourceid"]);
            lnkAddSlot.NavigateUrl = "SlotEdit.aspx?resourceid=" + _resourceId.ToString() + "&policyid=" + _policyId.ToString() + "&mode=new" + "&sectionid=" + _sectionid.ToString();
        }

        public IList<Slot> GetSlotList(string id, string rid)
        {

            Resource resource = new Resource();
            SchedulingPolicy policy = new SchedulingPolicy();

            Int32.TryParse(id, out _policyId);
            Int32.TryParse(rid, out _resourceId);
            if (_policyId > 0)
            {
                UserSession userSession = Helper.GetUserSession(Page);
                Factory factory = Helper.GetFactory(Page);
                MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
                resource = resourceService.Get(_resourceId);

                policy = resource.SchedulingPolicies.Single(p => p.Id == _policyId);
                
            }

            return policy.Slots.OrderBy(a => a.Time).ToList();
        }

        protected void gridBlockList_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Slot s = e.Row.DataItem as Slot;

                if (s != null)
                {
                    TimeZoneInfo tz1 = TimeZoneInfo.FindSystemTimeZoneById(Helper.GetUserSession(Page).CurrentSite.TimeZoneId);
                    TimeSpan tsTimeInTimeZone = s.Time.GetLocalFtomUtc(tz1);
                    e.Row.Cells[1].Text = new DateTime(tsTimeInTimeZone.Ticks).ToString("HH:mm");
                }

                HyperLink hSlotEdit = e.Row.RecursiveFindControl("hSlotEdit") as HyperLink;
                if (hSlotEdit != null)
                {
                    hSlotEdit.NavigateUrl = "~/Administration/Schedules/SlotEdit.aspx?resourceid=" + _resourceId.ToString() + "&policyid=" + _policyId.ToString() + "&slotid=" + s.Id.ToString() + "&mode=edit" + "&sectionid=" + _sectionid.ToString();
                }

                /*
                TimeZoneInfo tz = TimeZoneInfo.FindSystemTimeZoneById(Helper.GetUserSession(Page).CurrentSite.TimeZoneId);
                TimeSpan spn = tz.GetUtcOffset(DateTime.Today);
                TimeSpan mytimespan = Convert.ToDateTime(e.Row.Cells[1].Text).TimeOfDay;
                mytimespan = mytimespan + spn;
                e.Row.Cells[1].Text = mytimespan.ToString();
                */

            }
        }



    }
}