﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration.Schedules
{
    public partial class ScheduleList : System.Web.UI.Page
    {

        public int _ID = 0;
        public string _mode = "";
        public int _resourceID = 0;
        public int _sectionID = 0;

        protected void Page_Load(object sender, EventArgs e)
        {
            _sectionID = Helper.GetQueryStringInt(Request.QueryString["sectionid"]);
            _resourceID = Helper.GetQueryStringInt(Request.QueryString["id"]);
            if (!IsPostBack)
            {
                AddScheduleLink.NavigateUrl = "~\\Administration\\Schedules\\ScheduleEdit.aspx?resourceid=" + _resourceID.ToString() + "&sectionid=" + _sectionID.ToString() + "&mode=new";
            }
        }

        /// <summary>
        /// Get list of Schedule Policis to bind to grid
        /// </summary>
        /// <param name="id">The id of the Resource</param>
        /// <returns></returns>
        public IList<SchedulingPolicy> GetScheduleList(string id)
        {
            Resource resource = new Resource();
            int resourceID = 0;
            Int32.TryParse(id, out resourceID);
            if (resourceID > 0)
            {
                UserSession userSession = Helper.GetUserSession(Page);
                Factory factory = Helper.GetFactory(Page);
                MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
                resource = resourceService.Get(resourceID);
            }
            return resource.SchedulingPolicies.OrderBy(SchedulingPolicy => SchedulingPolicy.StartEffectDate).ToList();
        }

        protected void gridScheduleList_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            TimeZoneInfo tz = Helper.GetUserSession(Page).CurrentSite.GetTimeZoneInfo();
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                DateTime d = Convert.ToDateTime(e.Row.Cells[3].Text);

                e.Row.Cells[3].Text = TimeZoneInfo.ConvertTimeFromUtc(d, tz).ToString("dd-MMM-yyyy");

                d = Convert.ToDateTime(e.Row.Cells[2].Text);
                e.Row.Cells[2].Text = TimeZoneInfo.ConvertTimeFromUtc(d, tz).ToString("dd-MMM-yyyy");

                HyperLink link = e.Row.Cells[5].Controls[0] as HyperLink;
                if (link != null)
                {
                    link.Text = "Select";
                    link.NavigateUrl += "&resourceid=" + _resourceID.ToString() + "&sectionid=" + _sectionID.ToString();
                }
            }
        }


    }
}