﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="ScheduleEdit.aspx.cs" Inherits="BT.Health.SchedulingWeb.Administration.Schedules.ScheduleEdit" %>

<%@ Register Src="~/User_Controls/ctl_CurrentResource.ascx" TagName="ctl_CurrentResource" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <script type="text/javascript">
        // runs in Ajax panel pages
        function pageLoad(sender, args) {

            var $tbDateFrom = $('#<%= tbDateFrom.ClientID %>');
            var $tbDateTo = $('#<%= tbDateTo.ClientID %>');

            $tbDateFrom
            .attr("readonly", "readonly")
            .css("text-align", "center")
            .css("cursor", "pointer")
            .datepicker({
                dateFormat: "dd MM yy",
                changeMonth: true,
                changeYear: true,
                onSelect: function (dateText, inst) {

                    // if START date greater than END date, set end date to start date
                    if ($tbDateFrom.datepicker("getDate") > $tbDateTo.datepicker("getDate")) {
                        $tbDateTo.datepicker("setDate", $tbDateFrom.datepicker("getDate"));
                    }
                }
            });

            $tbDateTo
            .attr("readonly", "readonly")
            .css("text-align", "center")
            .css("cursor", "pointer")
            .datepicker({
                dateFormat: "dd MM yy",
                changeMonth: true,
                changeYear: true,
                onSelect: function (dateText, inst) {

                    // if END date less than START date, set start date to end date
                    if ($tbDateTo.datepicker("getDate") < $tbDateFrom.datepicker("getDate")) {
                        $tbDateFrom.datepicker("setDate", $tbDateTo.datepicker("getDate"));
                    }
                }
            });
        }
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <uc1:ctl_CurrentResource ID="ctl_CurrentResource1" runat="server" />
            <asp:Label ID="Label1" runat="server" Text="Scheduling Policy" Font-Bold="True"></asp:Label>
            <div style="height: 20px;">
                <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
            </div>
            <div style="height: 20px;">
                <asp:UpdateProgress ID="UpdateProgressPatientSearch" runat="server" DisplayAfter="0">
                    <ProgressTemplate>
                        <span style="color: #a49d1a;">Loading</span>&nbsp;<img src="/graphics/loading.gif" alt="loading data" title="loading data" />
                    </ProgressTemplate>
                </asp:UpdateProgress>
            </div>
            <table class="tblDataEntry" style="vertical-align: top;">
                <tr>
                    <td>Day of the week
                    </td>
                    <td style="width: 200px;">
                        <asp:DropDownList ID="ddlDay" runat="server" Style="width: 100%;">
                            <asp:ListItem Value="0">Sunday</asp:ListItem>
                            <asp:ListItem Value="1">Monday</asp:ListItem>
                            <asp:ListItem Value="2">Tuesday</asp:ListItem>
                            <asp:ListItem Value="3">Wednesday</asp:ListItem>
                            <asp:ListItem Value="4">Thursday</asp:ListItem>
                            <asp:ListItem Value="5">Friday</asp:ListItem>
                            <asp:ListItem Value="6">Saturday</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>Start Effect Date</td>
                    <td>
                        <asp:TextBox ID="tbDateFrom" runat="server" Style="width: 100%;"></asp:TextBox></td>
                </tr>
                <tr>
                    <td>End Effect Date</td>
                    <td>
                        <asp:TextBox ID="tbDateTo" runat="server" Style="width: 100%;"></asp:TextBox></td>
                </tr>
                <tr>
                    <td>Priority
                    </td>
                    <td>
                        <asp:DropDownList ID="ddlPriority" runat="server" Style="width: 100%;">
                            <asp:ListItem Text="1" Selected="True" />
                            <asp:ListItem Text="2" />
                            <asp:ListItem Text="3" />
                        </asp:DropDownList></td>
                </tr>
                <tr>
                    <td colspan="2" style="text-align: right;">
                        <asp:Button ID="btnAddUpdate" runat="server" Text="Add" OnClick="btnAddUpdate_Click" />
                    </td>
                </tr>
                <tr runat="server" id="trViewSlots" visible="false">
                    <td colspan="2" style="text-align: right !important;">

                        <asp:HyperLink ID="lnkSlots" runat="server" CssClass="linkWithSpace" style="text-align: right !important;">View Slots</asp:HyperLink>
                    </td>
                </tr>
            </table>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
