﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration.Schedules
{
    public partial class HoldList : System.Web.UI.Page
    {
        public int _resourceID = 0;

        protected void Page_Load(object sender, EventArgs e)
        {
            _resourceID = Helper.GetQueryStringInt(Request.QueryString["id"]);
            AddHoldLink.NavigateUrl = "HoldEdit.aspx?resourceid="+_resourceID.ToString()+"&id=0&mode=new";

        }

        public DataTable GetHoldList(string id)
        {
            DataTable dt = new DataTable("Hold");
            dt.Columns.Add("id");
            dt.Columns.Add("PeriodStart");
            dt.Columns.Add("PeriodEnd");
            dt.Columns.Add("AutoReleaseAt");
            dt.Columns.Add("ParentId");

            Int32.TryParse(id, out _resourceID);
            UserSession userSession = Helper.GetUserSession(Page);
            Factory factory = Helper.GetFactory(Page);

            MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
            Resource resource = resourceService.Get(_resourceID);
            TimeZoneInfo tz = Helper.GetUserSession(Page).CurrentSite.GetTimeZoneInfo();
            foreach (Hold h in resource.Holds)
            {
                dt.Rows.Add(h.Id, h.PeriodStart.ToMediumFormatFromUtc(tz), h.PeriodEnd.ToMediumFormatFromUtc(tz), h.AutoReleaseAt.ToMediumFormatFromUtcFromNullableDateTime(tz), _resourceID);
            }

            return dt;
        }
    }
}