﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration.Schedules
{
    public partial class HoldEdit : System.Web.UI.Page
    {
        public int _resourceID = 0;
        public int _ID = 0;
        public bool _modeEdit = false;

        protected void Page_Load(object sender, EventArgs e)
        {
            _resourceID = Helper.GetQueryStringInt(Request.QueryString["resourceid"]);
            _ID = Helper.GetQueryStringInt(Request.QueryString["id"]);
            _modeEdit = Request.QueryString["mode"].ToLower() == "edit";
            
            if (!IsPostBack)
            {

                // TODO needs to be in time zone of clinic



                //dtPeriodStart.SelectedTimeZone = TimeZoneInfo.Local;
                //dtpPeriodEnd.SelectedTimeZone = TimeZoneInfo.Local;
                //dtpReleaseAt.SelectedTimeZone = TimeZoneInfo.Local;
               
                //txtID.Text = (_modeEdit)?_ID.ToString():"";

                if (_modeEdit)
                {
                    UserSession userSession = Helper.GetUserSession(Page);
                    Factory factory = Helper.GetFactory(Page);
                    MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
                    Resource resource = resourceService.Get(_resourceID);

                    Hold h = resource.Holds.Single(p => p.Id == _ID);

                    dtPeriodStart.SelectedDateTimeUTC = h.PeriodStart;
                    dtpPeriodEnd.SelectedDateTimeUTC = h.PeriodEnd;
                    dtpReleaseAt.SelectedDateTimeUTC = h.AutoReleaseAt;
                    btnUpdate.Text = "Update";
                    btnRemove.Visible = true;
                }
                else
                {

                    dtPeriodStart.SelectedDateTimeUTC = DateTime.UtcNow;
                    dtpPeriodEnd.SelectedDateTimeUTC = DateTime.UtcNow;
                    dtpReleaseAt.SelectedDateTimeUTC = DateTime.UtcNow;
                    btnUpdate.Text = "Add";
                    btnRemove.Visible = false;
                }
            }

        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            UserSession userSession = Helper.GetUserSession(Page);
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
            Resource resource = resourceService.Get(_resourceID);
            Hold h = null;

            if (_modeEdit)
                h = resource.Holds.Single(p => p.Id == _ID);
            else
                h = new Hold();

            h.AutoReleaseAt = dtpReleaseAt.SelectedDateTimeUTC.Value;
            h.PeriodStart = dtPeriodStart.SelectedDateTimeUTC.Value;
            h.PeriodEnd = dtpPeriodEnd.SelectedDateTimeUTC.Value; 
//            h.Resource = resource;

            if (!_modeEdit)
                resource.AddHold(h);

            resourceService.Update(resource);
            Response.Redirect("HoldList.aspx?id=" + _resourceID.ToString());
        }

        protected void btnRemove_Click(object sender, EventArgs e)
        {
            try
            {
                Factory factory = Helper.GetFactory(Page);
                MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
                Resource resource = resourceService.Get(_resourceID);
                Hold h = null;
                h = resource.Holds.Single(p => p.Id == _ID);
                resource.Holds.Remove(h);
                resourceService.Update(resource);
            }
            catch (Exception exep)
            {
                //Logging code goes here
            }
            Response.Redirect("HoldList.aspx?id=" + _resourceID.ToString());
        }
    }
}