﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;
using System.Data;

namespace BT.Health.SchedulingWeb.Administration.Schedules
{
    public partial class BlockList : System.Web.UI.Page
    {
        public int _resourceID = 0;

        protected void Page_Load(object sender, EventArgs e)
        {
            _resourceID = Helper.GetQueryStringInt(Request.QueryString["id"]);
            AddBlockLink.NavigateUrl = "BlockEdit.aspx?resourceid=" + _resourceID.ToString() + "&id=0&mode=new";

        }

        public DataTable GetBlockList(string id)
        {
            string reason = "";
            DataTable dt = new DataTable("Block");
            dt.Columns.Add("id");
            dt.Columns.Add("PeriodStart");
            dt.Columns.Add("PeriodEnd");
            dt.Columns.Add("Reason");
            dt.Columns.Add("ParentId");

            Int32.TryParse(id, out _resourceID);
            UserSession userSession = Helper.GetUserSession(Page);
            Factory factory = Helper.GetFactory(Page);

            MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
            Resource resource = resourceService.Get(_resourceID);
            TimeZoneInfo tz = Helper.GetUserSession(Page).CurrentSite.GetTimeZoneInfo();
            foreach (Block b in resource.Blocks)
            {   
                reason = (b.Reason==null||b.Reason==string.Empty)?"":b.Reason;
                if (reason.Length>15) reason=reason.Substring(0,14) + " ...";

                dt.Rows.Add(b.Id, b.PeriodStart.ToMediumFormatFromUtc(tz), b.PeriodEnd.ToMediumFormatFromUtc(tz), reason, _resourceID);
            }

            return dt;
        }

        protected void DetailsView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
           
                
        }
    }
}