﻿/* 
 * SC-353
 * 
 * NOT DONE (because functionality was not available):
 *  - Present a list of appointments that will be cancelled
 *  - Cancel the appointments upon confirmation of the bloc
 *  - Send notification for cancellation
 * 
 * 
 * */

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration.Schedules
{
    public partial class BlockEdit : System.Web.UI.Page
    {

        private int _resourceID = 0;
        private int _ID = 0;
        private bool _modeEdit = false;

        protected void Page_Load(object sender, EventArgs e)
        {
            _resourceID = Helper.GetQueryStringInt(Request.QueryString["resourceid"]);
            _ID = Helper.GetQueryStringInt(Request.QueryString["id"]);
            _modeEdit = Request.QueryString["mode"].ToLower() == "edit";

            if (!IsPostBack)
            {
                //txtID.Text = (_modeEdit) ? _ID.ToString() : "";
                UserSession userSession = Helper.GetUserSession(Page);
                Factory factory = Helper.GetFactory(Page);
                MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
                Resource resource = resourceService.Get(_resourceID);
                //dtpStart.SelectedTimeZone = TimeZoneInfo.Local;
                //dtpEnd.SelectedTimeZone = TimeZoneInfo.Local;

                // TODO needs to be in time zone of clinic



                //TimeZoneInfo tz = Helper.GetUserSession(Page).CurrentSite.GetTimeZoneInfo();

                if (_modeEdit)
                {
                    Block b = resource.Blocks.Single(p => p.Id == _ID);
                    dtpStart.SelectedDateTimeUTC = b.PeriodStart;
                    dtpEnd.SelectedDateTimeUTC = b.PeriodEnd;
                    txtReason.Text = b.Reason;
                    btnUpdate.Text = "Continue";
                    btnRemoveBlock.Visible = true;
                    if (b.Recur != null)
                    {
                        BindRecur(b);
                        chkRecuring.Checked = true;
                      
                            chkRecuring.Checked = true;
                            tblRecur.Visible = true;
                            RequiredFieldValidator2.Enabled = true;
                            RegularExpressionValidator1.Enabled = true;
                       
                    }
                }
                else
                {
                    dtpStart.SelectedDateTimeUTC = DateTime.UtcNow;
                    dtpEnd.SelectedDateTimeUTC = DateTime.UtcNow;
                    txtReason.Text = "";
                    btnUpdate.Text = "Add";
                    btnRemoveBlock.Visible = false;
                }
            }
        }

        internal void BindRecur(Block b)
        {
            //WucRecStart.SelectedDateTimeUTC = b.Recur.RecurringStart;
            WucRecEnd.SelectedDateTimeUTC = b.Recur.RecurringEnd;
            txtInterval.Text = b.Recur.RecurringInterval;
            ddlFrequency.SelectedIndex = ddlFrequency.Items.IndexOf(ddlFrequency.Items.FindByValue(b.Recur.RecurringFrequency));

        }

        public Collection<Appointment> GetAppointments()
        {
            Collection<Appointment> app = null;
            UserSession userSession = Helper.GetUserSession(Page);
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.IAppointmentService appointmentService = factory.GetAppointmentService();
            app = appointmentService.GetForResource(_resourceID,
                dtpStart.SelectedDateTimeUTC,
                dtpEnd.SelectedDateTimeUTC);
            if (app != null)
            {
                lblErrorMessage.Text = "The following Appointments exist within this Block";
            }
            else
            {
                lblErrorMessage.Text = "";
            }
            return app;
           
                //DateTime.Parse(txtStart.Text + " " + txtStartTime.Text), DateTime.Parse(txtStart.Text + " " + txtStartTime.Text));
        }

        protected void dt_ServerValidate(object sender, ServerValidateEventArgs e)
        {
            try
            {
                string str = e.Value;
                DateTime datevalue = DateTime.Parse(str);
                //TimeSpan time = TimeSpan.Parse(txtStartTime.Text.Trim());
                e.IsValid = true;
            }
            catch (Exception ex)
            {
                e.IsValid = false;
            }
        }

        private bool CheckDateAndTimes()
        {
            bool ret = true;
            try
            {
                if (dtpStart.SelectedDateTimeUTC.Value >= dtpEnd.SelectedDateTimeUTC.Value)
                {
                    // set a message - start time cannot be on or after the end time
                }

            }
            catch (Exception ex)
            {
                ret = false;
            }

            return ret;
        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            if (CheckDateAndTimes())
            {
                Collection<Appointment> apps = GetAppointments();

                if (apps.Count > 0)
                {
                    grdAppointments.DataSource = apps;
                    grdAppointments.DataBind();
                    lblErrorMessage.Visible = false;
                    RequiredFieldValidator1.Enabled = true;
                    btnCreateBlock.Visible = true;
                    btnUpdate.Visible = false;
                }
                else
                {
                    UpdateBlockObject();
                }

            }
            else
            {
                lblErrorMessage.Visible = true;
            }
        }

        protected void HandleCommunicationQueueItem(Collection<Appointment> appointments)
        {
            try
            {
                Factory factory = Helper.GetFactory(Page);
                MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
                Resource resource = resourceService.Get(_resourceID);
                CommunicationTemplate communicationTemplate = null;

                //Check to see if a communication template of type cancellation exists for section/clinic
                //If not then check facility
                communicationTemplate = resource.Section.CommunicationTemplates.Single(p => p.Type == CommunicationType.Cancellation);
                if (communicationTemplate != null)
                {
                    communicationTemplate = resource.Section.Facility.CommunicationTemplates.Single(p => p.Type == CommunicationType.Cancellation);
                }
                MedRed.Services.Interfaces.IAppointmentService appointmentService = factory.GetAppointmentService();
                foreach (Appointment appointment in appointments)
                {
                  
                    if (communicationTemplate != null)
                    {
                        CommunicationQueueItem item = new CommunicationQueueItem();
                        CreateCommunicationQueueItem(item, appointment, communicationTemplate);
                    }

                }
            }
            catch (Exception exp)
            {
                //Logging goes here
            }
        }

        protected void CreateCommunicationQueueItem(CommunicationQueueItem item, Appointment app, CommunicationTemplate template)
        {
            //Populate CommunicationQueueItem
            item.Appointment = app;
            item.Subject = template.Subject;
            item.Body = template.Message;
            item.Recipient = template.Recipient;
            item.Medium = template.Medium;

            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.IAppointmentService appointmentService = factory.GetAppointmentService();
            appointmentService.AddToCommunicationQueue(item);
        }

        protected void UpdateBlockObject()
        {
            UserSession userSession = Helper.GetUserSession(Page);
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
            Resource resource = resourceService.Get(_resourceID);
            Block b = null;

            if (_modeEdit)
                b = resource.Blocks.Single(p => p.Id == _ID);
            else
                b = new Block();

            //b.PeriodStart = DateTime.Parse(txtStart.Text + " " + txtStartTime.Text);
            b.PeriodStart = dtpStart.SelectedDateTimeUTC.Value;
            b.PeriodEnd = dtpEnd.SelectedDateTimeUTC.Value;
            b.Reason = txtReason.Text;
           

            if (chkRecuring.Checked)
            {
               
                 if (b.Recur != null && _modeEdit)
                 {
                     b.Recur.RecurringStart = dtpStart.SelectedDateTimeUTC.Value;
                        b.Recur.RecurringEnd = WucRecEnd.SelectedDateTimeUTC.Value;
                        b.Recur.RecurringFrequency = ddlFrequency.SelectedValue;
                        b.Recur.RecurringInterval = txtInterval.Text;
                 }
                else
                 {
                    Recur rec = new Recur();
                    rec.RecurringStart = dtpStart.SelectedDateTimeUTC.Value;
                    rec.RecurringEnd = WucRecEnd.SelectedDateTimeUTC.Value;
                    rec.RecurringInterval = txtInterval.Text;
                    rec.RecurringFrequency = ddlFrequency.SelectedValue;
                    b.Recur = rec;
                }

            }


            if (!_modeEdit)
                resource.AddBlock(b);

            resourceService.Update(resource);
            Response.Redirect("BlockList.aspx?id=" + _resourceID.ToString());
        }

        protected void btnCreateBlock_Click(object sender, EventArgs e)
        {
            if (CheckDateAndTimes())
            {
                UpdateBlockObject();
                Collection<Appointment> apps = GetAppointments();
                if (apps.Count > 0)
                {
                    HandleCommunicationQueueItem(apps);
                }
                lblErrorMessage.Visible = false;
                Response.Redirect("BlockList.aspx?id=" + _resourceID.ToString());
            }
            else
            {
                lblErrorMessage.Visible = true;
            }
        }

        protected void datasourceAppointments_Filtering(object sender, ObjectDataSourceFilteringEventArgs e)
        {

        }

        protected void btnRemoveBlock_Click(object sender, EventArgs e)
        {
            try
            {
                Factory factory = Helper.GetFactory(Page);
                MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
                Resource resource = resourceService.Get(_resourceID);
                Block b = null;
                b = resource.Blocks.Single(p => p.Id == _ID);
                resource.Blocks.Remove(b);
                resourceService.Update(resource);
            }
            catch (Exception ex)
            {
                //Logging code goes here
            }
            Response.Redirect("BlockList.aspx?id=" + _resourceID.ToString());
        }

        protected void chkRecuring_CheckedChanged(object sender, EventArgs e)
        {
            if (chkRecuring.Checked)
            {
                tblRecur.Visible = true;
                RequiredFieldValidator2.Enabled = true;
                RegularExpressionValidator1.Enabled = true;
            }
            else
            {
                tblRecur.Visible = false;
                RequiredFieldValidator2.Enabled = false;
                RegularExpressionValidator1.Enabled = false;
            }
        }

        protected void grdAppointments_DataBound(object sender, EventArgs e)
        {

           

        }

        protected void grdAppointments_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            try
            {
                if (e.Row.RowType == DataControlRowType.DataRow)
                {
                    TimeZoneInfo tz1 = TimeZoneInfo.FindSystemTimeZoneById(Helper.GetUserSession(Page).CurrentSite.TimeZoneId);
                    //TimeSpan tsTimeInTimeZone = s.Time.GetLocalFtomUtc(tz1);
                    DateTime dt = Convert.ToDateTime(e.Row.Cells[1].Text);
                    dt.ToMediumFormatFromUtc(tz1);
                    e.Row.Cells[1].Text = dt.ToMediumFormatFromUtc(tz1).ToString();
                }
            }
            catch (Exception exept)
            {
                //Logging here
            }
        }
   


    }
}