﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration.Schedules
{
    public partial class ApointmentTypeListaspx : System.Web.UI.Page
    {

        int sectionId = 0;

        protected void Page_Load(object sender, EventArgs e)
        {

            sectionId = Helper.GetQueryStringInt(Request.QueryString["id"]);
            lnkApointmentType.NavigateUrl = "~\\Administration\\Schedules\\ApointmentTypeEdit.aspx?sectionId=" + sectionId.ToString() + "&mode=new";
        }


        public IList<AppointmentType> GeAppointmentTypeList(string id)
        {
            int appointmentTypeId = Helper.GetQueryStringInt(HttpContext.Current.Request.QueryString["id"]);
            Int32.TryParse(id, out appointmentTypeId);
            UserSession userSession = Helper.GetUserSession(Page);
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.ISectionService sectionService = factory.GetSectionService();
            Section clinic = sectionService.Get(appointmentTypeId);
            return clinic.AppointmentTypes;
        
        }

        protected void grdAppointmentLiat_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType ==DataControlRowType.DataRow)
            {
                //e.Row.Cells[3].Text += " TEST";
                HyperLink link = e.Row.Cells[5].Controls[0] as HyperLink;
                if (link != null)
                {
                    link.Text = "Select";
                    link.NavigateUrl += "&sectionId=" + sectionId.ToString();
                }
            }
        }

        protected void grdAppointmentLiat_DataBound(object sender, EventArgs e)
        {

        }


    }
}