﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using MedRed.Services;
using Shared.Model.Config.MDWS;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using System.Collections.ObjectModel;

namespace BT.Health.SchedulingWeb.Administration.Schedules
{
    public partial class ApointmentTypeEdit : System.Web.UI.Page
    {
        public int _sectionId = 0;
        public bool _modeEdit = false;
        public int _appointmentTypeId = 0;

        protected void Page_Load(object sender, EventArgs e)
        {
            _sectionId = Helper.GetQueryStringInt(Request.QueryString["sectionId"]);
            _modeEdit = Request.QueryString["mode"].ToLower() == "edit";
            _appointmentTypeId = Helper.GetQueryStringInt(Request.QueryString["id"]);
            if (!IsPostBack)
            {
        //        this.btnDelete.Attributes.Add("onclick",
        //"return DialogDelete.doConfirm(this, 'Are you sure you want to delete?', 'Confirm Delete');");
                BindStopCodes();
                ddlTypeCategory.DataBind();
                if (_modeEdit)
                {
                    UserSession userSession = Helper.GetUserSession(Page);
                    Factory factory = Helper.GetFactory(Page);
                    //MedRed.Services.Interfaces.IAppointmentService i = factory.GetAppointmentService();
                    //AppointmentTypeCategory c
                    
                    MedRed.Services.Interfaces.ISectionService sectionService = factory.GetSectionService();
                    Section section = sectionService.Get(_sectionId);

                    AppointmentType appType = section.AppointmentTypes.Single(p => p.Id == _appointmentTypeId);

                    txName.Text = appType.Name;
                    txtCreditCode.Text = appType.DSSCreditStopCode;

                    //ddlStopCode.SelectedIndex = ddlStopCode.Items.IndexOf(ddlStopCode.Items.FindByText(clinic.DSSPrimaryStopCode));
                    ddlStopCode.SelectedIndex = ddlStopCode.Items.IndexOf(ddlStopCode.Items.FindByValue(appType.DSSPrimaryStopCode));
                    ddlLengthOfSlot.SelectedIndex = ddlLengthOfSlot.Items.IndexOf(ddlLengthOfSlot.Items.FindByValue(appType.Duration.ToString()));
                    if (appType.AppointmentTypeCategory != null)
                    {
                        ddlTypeCategory.SelectedIndex = ddlTypeCategory.Items.IndexOf(ddlTypeCategory.Items.FindByValue(appType.AppointmentTypeCategory.Id.ToString()));
                    }
                        btnAdd.Text = "Update";
                        btnDelete.Visible = true;
                }
                else
                {
                    btnDelete.Visible = false;
                    btnAdd.Text = "Add";
                }
            }
        }

        private void BindStopCodes()
        {
            Collection<StopCode> codes = GetStopCodes();
            var codeQuery = codes.Select(p => new { Id = p.Code, DisplayText = p.Code + " " + p.Name });
            //var sorted = codeQuery.OrderBy(x => x.Id).ToList();
            ddlStopCode.DataSource = codeQuery;
            ddlStopCode.DataValueField = "Id";
            ddlStopCode.DataTextField = "DisplayText";
            ddlStopCode.DataBind();
        }

        private Collection<StopCode> GetStopCodes()
        {
            UserSession userSession = Helper.GetUserSession(Page);
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.INationalSystemService INationalSystemService = factory.GetNationalSystemService();
            Collection<StopCode> stopCodes = null;
            stopCodes = INationalSystemService.GetStopCodes(userSession.CurrentSite.VistaSiteId.ToString());
            return stopCodes;
        }

        /// <summary>
        /// Get type categories
        /// </summary>
        /// <returns>Collection of AppointmentTypeCategory</returns>
        public Collection<AppointmentTypeCategory> GetTypeCategory()
        {
            UserSession userSession = Helper.GetUserSession(Page);
            Collection<AppointmentTypeCategory> catCollection = new Collection<AppointmentTypeCategory>();

            if (userSession != null)
            {
                Shared.Model.Site currentSite = userSession.CurrentSite;
                Factory factory = Helper.GetFactory(Page);
                MedRed.Services.Interfaces.INationalSystemService systemService = factory.GetNationalSystemService();
                catCollection = systemService.GetAppointmentTypeCategories(currentSite.VistaSiteId);
            }
            return catCollection;
        }

        protected void btnAdd_Click(object sender, EventArgs e)
        {
            UserSession userSession = Helper.GetUserSession(Page);
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.ISectionService sectionService = factory.GetSectionService();
            Section section = sectionService.Get(_sectionId);
            try
            {
                AppointmentType appType = null;

                if (_modeEdit)
                    appType = section.AppointmentTypes.Single(p => p.Id == _appointmentTypeId);
                else
                    appType = new AppointmentType();
                MedRed.Services.Interfaces.INationalSystemService nationalService = factory.GetNationalSystemService();

                if (ddlTypeCategory.SelectedIndex != -1)
                {
                    int categoryChosen = Convert.ToInt16(ddlTypeCategory.SelectedValue);
                    if (categoryChosen != -1)
                    {
                        Collection<AppointmentTypeCategory> categories = nationalService.GetAppointmentTypeCategories(section.Facility.Site.VistaSiteId);
                        appType.AppointmentTypeCategory = categories.Single(p => p.Id == categoryChosen);
                    }
                }
                appType.DSSCreditStopCode = txtCreditCode.Text.Trim();
                appType.DSSPrimaryStopCode = ddlStopCode.SelectedValue.ToString();
                appType.Duration = Convert.ToInt16(ddlLengthOfSlot.SelectedValue);
                appType.Name = txName.Text.Trim();

                if (!_modeEdit)
                    section.AddAppointmentType(appType);

                sectionService.Update(section);
            }
            catch (Exception exept)
            {
                //Logging here
            }
            Response.Redirect("ApointmentTypeListaspx.aspx?id=" + _sectionId.ToString());
        }

        protected void btnDelete_Click(object sender, EventArgs e)
        {
            try
            {
                Factory factory = Helper.GetFactory(Page);
                MedRed.Services.Interfaces.ISectionService sectionService = factory.GetSectionService();
                Section section = sectionService.Get(_sectionId);
                AppointmentType appType = section.AppointmentTypes.Single(p => p.Id == _appointmentTypeId);
                section.AppointmentTypes.Remove(appType);
                sectionService.Update(section);
               
            }
            catch (Exception ee)
            {
                //Logging here 
            }
            Response.Redirect("ApointmentTypeListaspx.aspx?id=" + _sectionId.ToString(), false);
        }


       
    
    
    }


}