﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration.Resources
{
    public partial class RoomList : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
           lnkAddRoom.NavigateUrl = "RoomEdit.aspx?mode=new";
        }


        /// <summary>
        /// Get a collection of rooms for the siteid
        /// </summary>
        /// <param name="id">the id of the cuirrent site</param>
        /// <returns>Rooms collection</returns>
        public Collection<Room> GetRoomList(string id)
        {
            int siteID = 0;
            Int32.TryParse(id, out siteID);
            UserSession userSession = Helper.GetUserSession(Page);
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.IRoomService roomService = factory.GetRoomService();
            Collection<Room> roomList = roomService.GetAllForSite(userSession.CurrentSite.Id);
            return roomList;
        }





    }
}