﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration.Resources
{
    public partial class RoomEdit : System.Web.UI.Page
    {

        public int _ID = 0;
        public bool _modeEdit = false;


        protected void Page_Load(object sender, EventArgs e)
        {
            _ID = Helper.GetQueryStringInt(Request.QueryString["roomId"]);
            _modeEdit = Request.QueryString["mode"].ToLower() == "edit";

            if (!IsPostBack)
            {
                if (_modeEdit)
                {
                    Factory factory = Helper.GetFactory(Page);
                    MedRed.Services.Interfaces.IRoomService roomService = factory.GetRoomService();
                    Room room = roomService.Get(_ID);
                    txtFloor.Text = room.Floor;
                    txtName.Text = room.Name;
                    btnUpdate.Text = "Update";
                }
                else
                {
                    btnUpdate.Text = "Add";
                }
            }
        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.IRoomService roomService = factory.GetRoomService();
            Room room;

            if (_modeEdit)
            {
                room = roomService.Get(_ID);
            }
            else
            {
                MedRed.Services.Interfaces.ISiteService siteService = factory.GetSiteService();
                UserSession userSession = Helper.GetUserSession(Page);
                Site site = siteService.Get(userSession.CurrentSite.Id);
                room = new Room();
                room.Site = site;
            }
            room.Name = txtName.Text.Trim();
            room.Floor = txtFloor.Text.Trim();

            if (!_modeEdit)
                roomService.Add(room);

            roomService.Update(room);
            Response.Redirect("RoomList.aspx");
        }



    }
}