﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration
{
    public partial class ResourceList : System.Web.UI.Page
    {

        private int _resourceID = 0;
        private int _sectionid = 0;
        protected void Page_Load(object sender, EventArgs e)
        {
            _sectionid = Helper.GetQueryStringInt(Request.QueryString["id"]);
            _resourceID = Helper.GetQueryStringInt(Request.QueryString["id"]);
            AddResourceLink.NavigateUrl = "ResourceEdit.aspx?id=" + Request.QueryString["id"] + "&mode=new";
            if (!IsPostBack)
            {
                Collection<Resource> resource = GetResourceList(Request.QueryString["id"]);
            }
           
        }


        /// <summary>
        /// Get a list of resources for a clinic
        /// </summary>
        /// <param name="id">clinic or section ID</param>
        /// <returns> Collection of Resources</returns>
        public Collection<Resource> GetResourceList(string id)
        {
            
            int clinicID = 0;
            Int32.TryParse(id, out clinicID);

            UserSession userSession = Helper.GetUserSession(Page);

            Factory factory = Helper.GetFactory(Page);

            MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();

            Collection<Resource> resourceList = resourceService.GetAll(clinicID);

            return resourceList; 
        }

        protected void gridResourceList_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        protected void gridResourceList_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                HyperLink link = e.Row.Cells[7].Controls[0] as HyperLink;
                if (link != null)
                {
                    link.Text = "Select";
                    link.NavigateUrl += "&sectionid=" + _sectionid.ToString();
                }
            }
        }
    }
}