﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration
{
    public partial class ResourceEdit : System.Web.UI.Page
    {

        public int _ID = 0;
        public string _mode = "";

        protected void Page_Load(object sender, EventArgs e)
        {
            //Resource resource = GetResource(Request.QueryString["id"]);
            if (!IsPostBack)
            {
                _mode = Request.QueryString["mode"];
                lblId.Text = Request.QueryString["id"];
                cboResourceType.DataSource = Enum.GetNames(typeof(ResourceType));
                cboResourceType.DataBind();
                cboResourceType_SelectedIndexChanged(null, null);
                if (_mode == "edit")
                {
                    btnAdd.Visible = false;
                    btnUpdate.Visible = true;
                    GetResource(lblId.Text);
                }
                else
                {
                    btnAdd.Visible = true;
                    btnUpdate.Visible = false;
                }
                
            }
        }

        private void BindForm(Resource r)
        {   

        }

        /// <summary>
        /// Get a resource
        /// </summary>
        /// <param name="id">resource id</param>
        /// <returns>Resource</returns>
        public void GetResource(string id)
        {
            Resource resource = null;

            int resourceID = 0;
            Int32.TryParse(id, out resourceID);

            if (resourceID > 0)
            {
                UserSession userSession = Helper.GetUserSession(Page);
                Factory factory = Helper.GetFactory(Page);
                MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
                resource = resourceService.Get(resourceID);
                if (resource != null)
                {
                    txtName.Text = resource.Name;
                    //txtServiceType.Text = resource.ServiceType;
                    chkAllowOverbooking.Checked = resource.AllowOverbooking;
                    cboResourceType.SelectedIndex = cboResourceType.Items.IndexOf(cboResourceType.Items.FindByValue(resource.Type.ToString()));
                    cboResourceType_SelectedIndexChanged(null, null);
                    cboProvider.SelectedIndex = cboProvider.Items.IndexOf(cboProvider.Items.FindByValue(resource.FullfillingResourceId.ToString()));
                    
                }
            }
           
        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            try
            {
                UserSession userSession = Helper.GetUserSession(Page);
                Section clinic = new Section();
                if (userSession != null)
                {

                    Factory factory = Helper.GetFactory(Page);
                    MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();

                    Resource r = resourceService.Get(Convert.ToInt16(lblId.Text));
                    if (r != null)
                    {

                        r.Name = txtName.Text.Trim();
                        r.AllowOverbooking = chkAllowOverbooking.Checked;
                        //r.ServiceType = txtServiceType.Text.Trim();
                        r.Type = (ResourceType)Enum.Parse(typeof(ResourceType), cboResourceType.SelectedItem.ToString(), true);
                        //r.FullfillingResourceId = Convert.ToInt16(cboProvider.DataValueField);
                        r.FullfillingResourceId = Convert.ToInt16(cboProvider.SelectedValue);
                        resourceService.Update(r);
                    }
                    Response.Redirect("ResourceList.aspx?id=" + r.Section.Id.ToString());
                }
            }
            catch (Exception ex)
            {
                //Log exception code here
            }
            //EmployeeType empType= (EmployeeType)Enum.Parse(ddl.SelectedValue); 
        }

        //public Collection<ResourceType> getResourceTypes()
        //{
        //    UserSession userSession = Helper.GetUserSession(Page);
        //    Factory factory = Helper.GetFactory(Page);
        //    MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
        //}

        protected void btnAdd_Click(object sender, EventArgs e)
        {
            try
            {
                UserSession userSession = Helper.GetUserSession(Page);
                Factory factory = Helper.GetFactory(Page);
                MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
                MedRed.Services.Interfaces.ISectionService sectService = factory.GetSectionService();

                Section s = new Section();
                s = sectService.Get(Convert.ToInt16(lblId.Text));
                if (s != null)
                {
              
                    Resource r = new Resource();
                    r.Name = txtName.Text.Trim();
                    r.AllowOverbooking = chkAllowOverbooking.Checked;
                    //r.ServiceType = txtServiceType.Text.Trim();
                    r.Type = (ResourceType)Enum.Parse(typeof(ResourceType), cboResourceType.SelectedItem.ToString(), true);
                    //r.FullfillingResourceId = Convert.ToInt16(cboProvider.DataValueField);
                    r.Section = s;
                    r.FullfillingResourceId = Convert.ToInt16(cboProvider.SelectedValue);
                    resourceService.Add(r);

                }
                Response.Redirect("ResourceList.aspx?id=" + s.Id.ToString());
            }
            catch (Exception ex)
            {
                //Log exception code here
            }
        }


        public Collection<Provider> GetProviders()
        {
            UserSession userSession = Helper.GetUserSession(Page);
            Collection<Provider> providers = null;
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.IProviderService providerService = factory.GetProviderService();
            providers = providerService.GetAllForSite(userSession.CurrentSite.Id);
            return providers;

        }

        protected void cboResourceType_SelectedIndexChanged(object sender, EventArgs e)
        {
            ResourceType resourceType = (ResourceType)Enum.Parse(typeof(ResourceType), cboResourceType.SelectedItem.ToString(), true);
            if (resourceType != null)
            {
                this.cboProvider.Enabled = true;
                switch (resourceType.ToString())
                {
                    case "Equipment":
                        BindEquipment(cboResourceType);
                        break;
                    case "Provider":
                        BindProvider(cboResourceType);
                        break;
                    case "Room":
                        BindRoom(cboResourceType);
                        break;
                }
            }
        }





        /// <summary>
        /// Bind dropdownlist with Providers for site
        /// </summary>
        /// <param name="dd">dropdownlist</param>
        private void BindProvider(DropDownList dd)
        {
            UserSession userSession = Helper.GetUserSession(Page);
            Collection<Provider> providers = null;
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.IProviderService providerService = factory.GetProviderService();
            providers = providerService.GetAllForSite(userSession.CurrentSite.Id);
            if (providers != null && providers.Count > 0)
            {
                //Provider p = new Provider();
                //p.Person.LastName
                cboProvider.DataSource = providers;
                cboProvider.DataValueField = "Id";
                cboProvider.DataTextField = "Person";
                cboProvider.DataBind();
                cboProvider.Enabled = true;
            }
            else
            {
                cboProvider.Enabled = false;
            }
        }

        /// <summary>
        /// Bind dropdownlist with Rooms for site
        /// </summary>
        /// <param name="dd">dropdownlist</param>
        private void BindRoom(DropDownList dd)
        {
            UserSession userSession = Helper.GetUserSession(Page);
            Collection<Room> rooms = null;
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.IRoomService roomService = factory.GetRoomService();
            rooms = roomService.GetAllForSite(userSession.CurrentSite.Id);
            if (rooms != null && rooms.Count > 0)
            {
                cboProvider.DataSource = rooms;
                cboProvider.DataValueField = "Id";
                cboProvider.DataTextField = "Name";
                cboProvider.DataBind();
                cboProvider.Enabled = true;
            }
            else
            {
                cboProvider.Enabled = false;
            }
        }

        /// <summary>
        /// Bind dropdownlist with Equipment for site
        /// </summary>
        /// <param name="dd">dropdownlist</param>
        private void BindEquipment(DropDownList dd)
        {
            UserSession userSession = Helper.GetUserSession(Page);
            Collection<Equipment> equipment = null;
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.IEquipmentService equipmentService = factory.GetEquipmentService();
            equipment = equipmentService.GetAllForSite(userSession.CurrentSite.Id);
            if (equipment != null && equipment.Count>0)
            {
                cboProvider.DataSource = equipment;
                cboProvider.DataTextField = "Name";
                cboProvider.DataValueField = "Id";
                cboProvider.DataBind();
                cboProvider.Enabled = true;
            }
            else
            {
                cboProvider.Enabled = false;
            }
        }
 

    }
}