﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration
{
    public partial class ResouceDetails : System.Web.UI.Page
    {
        public int _sectionID = 0;

        protected void Page_Load(object sender, EventArgs e)
        {
            _sectionID = Helper.GetQueryStringInt(Request.QueryString["sectionid"]);
            Resource resource = GetResource(Request.QueryString["id"]);
            ScheduleLink.NavigateUrl = "~\\Administration\\Schedules\\ScheduleList.aspx?id=" + Request.QueryString["id"] + "&sectionid=" + _sectionID.ToString() ;
            lnkBlockList.NavigateUrl = "~\\Administration\\Schedules\\BlockList.aspx?id=" + resource.Id.ToString();
            lnkOnHoldList.NavigateUrl = "~\\Administration\\Schedules\\HoldList.aspx?id=" + resource.Id.ToString();

        }


  
        /// <summary>
        /// Get resource . Used as source for ObjectDataSource
        /// </summary>
        /// <param name="id">resource ID</param>
        /// <returns>Resource</returns>
        public Resource GetResource(string id)
        {
            Resource resource = new Resource();

            int resourceID = 0;
            Int32.TryParse(id, out resourceID);

            if (resourceID > 0)
            {
                
                UISession.Helper.GetUserSession(Page).CurrentResource = resource;
                Factory factory = Helper.GetFactory(Page);
                MedRed.Services.Interfaces.IResourceService resourceService = factory.GetResourceService();
                resource = resourceService.Get(resourceID);
                UISession.Helper.GetUserSession(Page).CurrentResource = resource;
            }
            return resource;
        }
    }
}