﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration.Resources
{
    public partial class EquipmentList : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            int siteId = Helper.GetQueryStringInt(Request.QueryString["id"]);
            lnkAddEquipment.NavigateUrl = "EquipmentEdit.aspx?mode=new";
        }

        /// <summary>
        /// Get all equipment 
        /// </summary>
        /// <param name="id">site id</param>
        /// <returns>Collection of Equipment</returns>
        public Collection<Equipment> GetEquipmentList(string id)
        {
            int siteID = 0;
            Int32.TryParse(id, out siteID);
            UserSession userSession = Helper.GetUserSession(Page);
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.IEquipmentService equipmentService = factory.GetEquipmentService();
            Collection<Equipment> equipmentList = equipmentService.GetAllForSite(userSession.CurrentSite.Id);
            return equipmentList;
        }

    }
}