﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration.Resources
{
    public partial class EquipmentEdit : System.Web.UI.Page
    {

        public int _ID = 0;
        public bool _modeEdit = false;

        protected void Page_Load(object sender, EventArgs e)
        {
             _ID = Helper.GetQueryStringInt(Request.QueryString["roomId"]);
            _modeEdit = Request.QueryString["mode"].ToLower() == "edit";

            if (!IsPostBack)
            {
                if (_modeEdit)
                {
                    Factory factory = Helper.GetFactory(Page);
                    MedRed.Services.Interfaces.IEquipmentService equipmentService = factory.GetEquipmentService();
                    Equipment equipment = equipmentService.Get(_ID);
                    txtType.Text = equipment.Type;
                    txtName.Text = equipment.Name;
                    btnUpdate.Text = "Update";
                }
                else
                {
                    btnUpdate.Text = "Add";
                }
        }
    }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.IEquipmentService equipmentService = factory.GetEquipmentService();
            Equipment equipment;

            if (_modeEdit)
            {
                equipment = equipmentService.Get(_ID);
            }
            else
            {
                MedRed.Services.Interfaces.ISiteService siteService = factory.GetSiteService();
                UserSession userSession = Helper.GetUserSession(Page);
                Site site = siteService.Get(userSession.CurrentSite.Id);
                equipment = new Equipment();
                equipment.Site = site;

            }
            equipment.Name = txtName.Text.Trim();
            equipment.Type = txtType.Text.Trim();

            if (!_modeEdit)
                equipmentService.Add(equipment);

            equipmentService.Update(equipment);
            Response.Redirect("EquipmentList.aspx");
        }

    }
}