﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration
{
    public partial class FacilityList : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            UISession.Helper.GetUserSession(Page).CurrentResource = null;

        }

        public Collection<FacilityDisplay> GetFacilityList()
        {
            UserSession userSession = Helper.GetUserSession(Page);

            Factory factory = Helper.GetFactory(Page);

            MedRed.Services.Interfaces.IFacilityService facilityService = factory.GetFacilityService();

            Collection<Facility> facilityList = facilityService.GetAll(userSession.CurrentSite.Id);
            Collection<FacilityDisplay> facilityDisplays = new Collection<FacilityDisplay>();
            foreach (Facility f in facilityList)
            {
                FacilityDisplay d = new FacilityDisplay();
                d.Id = f.Id;
                d.City = f.Address.City;
                d.Hours = f.Hours;
                d.Name = f.Name;
                d.Phone = f.Phone;
                d.ShortName = f.ShortName;
                d.State = f.Address.State;
                d.Street1 = f.Address.Street1;
                d.Street2 = f.Address.Street2;
                d.Street3 = f.Address.Street3;
                d.ZipCode = f.Address.Zip;
                facilityDisplays.Add(d);
            }
            return facilityDisplays; ;
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                e.Row.Cells[2].Text = Helper.GetTelephone(e.Row.Cells[2].Text);
            }
        }

        
    }

    public class FacilityDisplay
    {
        public virtual int Id { get; set; }
        public virtual string Name { get; set; }
        public virtual string Phone { get; set; }
        public virtual string Hours { get; set; }
        public virtual string ShortName { get; set; }
        public virtual string State { get; set; }
        public virtual string City { get; set; }
        public virtual string Street1 { get; set; }
        public virtual string Street2 { get; set; }
        public virtual string Street3 { get; set; }
        public virtual string ZipCode { get; set; }

    }
}