﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using MedRed.Services;
using Shared.Model;
using BT.Health.SchedulingWeb.Account;
using BT.Health.SchedulingWeb.UISession;

namespace BT.Health.SchedulingWeb.Administration
{
    public partial class AddSection : System.Web.UI.Page
    {
        public int _ID = 0;
        public string _mode = "";
       

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                _ID = Helper.GetQueryStringInt(Request.QueryString["id"]);
                _mode = Request.QueryString["mode"];
                this.lblId.Text = Request.QueryString["id"];
                UISession.Helper.GetUserSession(Page).CurrentResource = null;

                if (_mode != "edit")
                {
                    btnAdd.Visible = true;
                    btnUpdate.Visible = false;
                }
                else
                {
                    btnAdd.Visible = false;
                    btnUpdate.Visible = true;
                    DoDataBind();
                }
            }
        }

        public void DoDataBind()
        {
            Facility f = GetFacility();
            f.Id = Convert.ToInt16(lblId.Text);
            txName.Text =  f.Name;
            txPhone.Text= f.Phone;
            txtHours.Text = f.Hours;
        }

        public void UpdateFacity()
        {
            try
            {
                //InsertClinic code
                // Int32.TryParse(id, out _clinicID);
                Facility f = GetFacility();
                f.Id = Convert.ToInt16(lblId.Text);
                f.Name = txName.Text.Trim();
                f.Phone = txPhone.Text.Trim();
                f.Hours = txtHours.Text.Trim();
                //f.Site = txtSite.Text.Trim();
                UISession.Helper.GetUserSession(Page).Facil = f;
                UISession.Helper.GetUserSession(Page).Clinic = null;
                Site s = new Site();
                s = UISession.Helper.GetUserSession(Page).CurrentSite;

                UserSession userSession = Helper.GetUserSession(Page);
                if (userSession != null && Convert.ToInt16(lblId.Text) > 0)
                {
                    Shared.Model.Site currentSite = userSession.CurrentSite;
                    Factory factory = Helper.GetFactory(Page);

                    MedRed.Services.Interfaces.IFacilityService facilityService = factory.GetFacilityService();
                    facilityService.Update(f);
                    Response.Redirect("FacilityList.aspx?id=" + lblId.Text);
                }

            }
            catch (Exception e)
            {
                //Log exception code to be added here
            }
        }

        public Facility GetFacility()
        {

           // Int32.TryParse(id, out _ID);
            int ident = Convert.ToInt16(this.lblId.Text);
            UserSession userSession = Helper.GetUserSession(Page);
            Facility facility = new Facility();

            if (userSession != null && ident > 0)
            {
                Shared.Model.Site currentSite = userSession.CurrentSite;
                Factory factory = Helper.GetFactory(Page);

                MedRed.Services.Interfaces.IFacilityService facilityService = factory.GetFacilityService();
                facility = facilityService.Get(ident);
            }
            return facility; 

        }

        protected void btnAdd_Click(object sender, EventArgs e)
        {

        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            UpdateFacity();
        }


        //public List<Facility> GetFacilitys()
        //{
           // VistaInstance instance = Helper.GetUserSession(Page).Instance;
           // if (instance.ConnectionType == "Default")
            //{
              // return MedRed.Services.Services.GetServices(ConnectionHelper.GetDefaultConfig(), ConnectionHelper.GetConnectionFor(instance.SiteID)).Facility.GetAll(instance.SiteID).ToList();
          //  }
           // else
            //{
              //  return MedRed.Services.Services.GetServices(ConnectionHelper.GetVistAEMRConfig(), ConnectionHelper.GetConnectionFor(instance.SiteID)).Patient.Search(instance.SiteID, searchParam).ToList();
           // }
            
       // }


    }
}