﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;


namespace BT.Health.SchedulingWeb.Administration
{
    public partial class FacilityDetails : System.Web.UI.Page
    {
 
        public int _facilityID=0;

        protected void Page_Load(object sender, EventArgs e)
        {
            UISession.Helper.GetUserSession(Page).CurrentResource = null;
            _facilityID = Helper.GetQueryStringInt( Request.QueryString["id"]);
            ViewClinicsLink.NavigateUrl = "ClinicList.aspx?id=" + _facilityID.ToString();
            TemplatesLink.NavigateUrl = "~\\Administration\\Templates\\TemplateList.aspx?facility=Y&id=" + _facilityID.ToString();
        }

        public FacilityDisplay GetFacility(string id)
        {

            Int32.TryParse(id, out _facilityID);
            UserSession userSession = Helper.GetUserSession(Page);
            Facility facility = new Facility();
            FacilityDisplay d = new FacilityDisplay();
            if (userSession != null && _facilityID>0)
            {
                Shared.Model.Site currentSite = userSession.CurrentSite;
               Factory factory = Helper.GetFactory(Page);

                MedRed.Services.Interfaces.IFacilityService facilityService = factory.GetFacilityService();
                facility = facilityService.Get(_facilityID);
                userSession.Facil = facility;
                
                d.Id = facility.Id;
                d.City = facility.Address.City;
                d.Hours = facility.Hours;
                d.Name = facility.Name;
                d.Phone = facility.Phone;
                d.ShortName = facility.ShortName;
                d.State = facility.Address.State;
                d.Street1 = facility.Address.Street1;
                d.Street2 = facility.Address.Street2;
                d.Street3 = facility.Address.Street3;
                d.ZipCode = facility.Address.Zip;
                userSession.Clinic = null;
            }
            return d;

        }

    }

 
}