﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration
{
    public partial class Sections : System.Web.UI.Page
    {
        int facilityID;
        protected void Page_Load(object sender, EventArgs e)
        {
            UISession.Helper.GetUserSession(Page).CurrentResource = null;
            facilityID = Helper.GetQueryStringInt(Request.QueryString["id"]);
            AddClinicLink.NavigateUrl = "ClinicEdit.aspx?id=" + facilityID.ToString() + "&mode=new";
        }


        /// <summary>
        /// Get list of clinics
        /// </summary>
        /// <param name="id">facility ID</param>
        /// <returns>Collection of Sections for facility</returns>
        public Collection<Section> GetClinicListing(string id)
        {
            int facilityID = Helper.GetQueryStringInt(HttpContext.Current.Request.QueryString["id"]);
            Int32.TryParse(id, out facilityID);
            UserSession userSession = Helper.GetUserSession(Page);
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.ISectionService sectionService = factory.GetSectionService();
            Collection<Section> sectionList = sectionService.GetAll(facilityID);
            return sectionList;
        }

        protected void gridResourceList_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                //try
                //{
                //    string st = e.Row.Cells[0].Text;
                //    Factory factory = Helper.GetFactory(Page);
                //    MedRed.Services.Interfaces.ISectionService sService = factory.GetSectionService();
                //    Section s = sService.Get(Convert.ToInt16(st));
                //    AppointmentType a = s.AppointmentTypes.Single(p => p.DSSPrimaryStopCode == e.Row.Cells[2].Text);
                //    e.Row.Cells[2].Text += " ";
                //    e.Row.Cells[2].Text += a.Name;
                //    //Section section = sectionService.Get(_sectionId);

                //    //    section.AppointmentTypes.Single(p => p.Id == _appointmentTypeId);
                //}
                //catch (Exception exept)
                //{
                //    //Logginf here
                //}
            }
        }

        //protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        //{
        //    //if (e.Row.RowType == DataControlRowType.DataRow)
        //    //{
        //    //    HyperLink link = e.Row.Cells[5].Controls[0] as HyperLink;
        //    //    if (link != null)
        //    //    {
        //    //        link.Text = "Select";
        //    //        link.NavigateUrl += "&sectionid=" + _sectionID.ToString();
        //    //    }
        //    //}
        //}

    }
}