﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;


namespace BT.Health.SchedulingWeb.Administration
{
    public partial class ClinicEdit : System.Web.UI.Page
    {
        public int _ID = 0;
        public string _mode = "";

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                UISession.Helper.GetUserSession(Page).CurrentResource = null;
                BindServiceType();
                BindStopCodes();
                _ID = Helper.GetQueryStringInt(Request.QueryString["id"]);
                _mode = Request.QueryString["mode"];
                this.lblId.Text = Request.QueryString["id"];
                if (_mode == "edit")
                {
                    Button1.Visible = false;
                    btnUpdate.Visible = true;
                    GetClinic(_ID);
                }
                else
                {
                    Button1.Visible = true;
                    btnUpdate.Visible = false;
                }
            }
        }

        public void BindServiceType()
        {
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.INationalSystemService sectionService = factory.GetNationalSystemService();
            Collection<Service> services = sectionService.GetServices();

            ddlServiceType.DataSource = services;
            ddlServiceType.DataValueField = "Id";
            ddlServiceType.DataTextField = "Name";
            ddlServiceType.DataBind();
        }

        private void BindStopCodes()
        {
            Collection<StopCode> codes = GetStopCodes();
            var codeQuery = codes.Select(p => new { Id = p.Code, DisplayText = p.Code + " " + p.Name });
            //var sorted = codes.OrderBy(x => x.Code).ToList();
            ddlStopCode.DataSource = codeQuery;
            ddlStopCode.DataValueField = "Id";
            ddlStopCode.DataTextField = "DisplayText";
            ddlStopCode.DataBind();
        }

        private Collection<StopCode> GetStopCodes()
        {
            UserSession userSession = Helper.GetUserSession(Page);
            Factory factory = Helper.GetFactory(Page);
            MedRed.Services.Interfaces.INationalSystemService INationalSystemService = factory.GetNationalSystemService();
            Collection<StopCode> stopCodes = null;
            stopCodes = INationalSystemService.GetStopCodes(userSession.CurrentSite.VistaSiteId.ToString(), RestrictionType.Primary);
            return stopCodes;
        }

        public void InsertClinic()
        {
            try
            {
                    //InsertClinic code
                    // Int32.TryParse(id, out _clinicID);
                    Factory factory = Helper.GetFactory(Page);
                    Facility f = factory.GetFacilityService().Get(Convert.ToInt16(lblId.Text));
                    //Facility f = new Facility();
                    //f.Id = Convert.ToInt16(lblId.Text);
                    UserSession userSession = Helper.GetUserSession(Page);
                    Section clinic = new Section();
                    clinic.Name = txName.Text.Trim();
                    clinic.Hours = txHours.Text.Trim();
                    clinic.DSSPrimaryStopCode = ddlStopCode.SelectedItem.ToString();
                    clinic.Location = txtLocation.Text.Trim();
                    clinic.Abbreviation = txtAbbreviations.Text.Trim();
                    //clinic.DSSCreditStopCode = txtDSSCreditStopCode.Text.Trim();
                    clinic.Facility = f;
                    Service s = new Service();
                    s.Id = ddlServiceType.SelectedValueAsInt();
                    s.Name = ddlServiceType.SelectedItem.ToString();
                    clinic.Service = s;
                    if (userSession != null && Convert.ToInt16(lblId.Text) > 0)
                    {
                        Shared.Model.Site currentSite = userSession.CurrentSite;
//                        Factory factory = Helper.GetFactory(Page);

                        MedRed.Services.Interfaces.ISectionService sectionyService = factory.GetSectionService();
                        clinic = sectionyService.Add(clinic);
                        /*
                        Auditing.Logger.Log(
                            Auditing.LogType.Information,
                            0,
                           Auditing.ObjectType.Facility,
                            Auditing.FacilityFunction.CommuncationTemplateRemoved,
                            clinic.Id,
                            clinic.Name,
                            Auditing.Status.Success,
                            false,
                            string.Format("DSSPrimaryStopCode={0},Location={0}", clinic.DSSPrimaryStopCode, clinic.Location));
                        */
                        Response.Redirect("ClinicList.aspx?id=" + lblId.Text, false);
                    }
               
            }
            catch (Exception e)
            {
                int i = 8;
               //Log exception code to be added here
            }
            Response.Redirect("ClinicList.aspx?id=" + lblId.Text, false);
        }

        //private Section PopulateObject()
       // {


       // }

        public void GetClinic(int id)
        {

            //Int32.TryParse(id, out _ID);

            UserSession userSession = Helper.GetUserSession(Page);
            Section clinic = new Section();

            if (userSession != null && _ID > 0)
            {
                Shared.Model.Site currentSite = userSession.CurrentSite;
                Factory factory = Helper.GetFactory(Page);

                MedRed.Services.Interfaces.ISectionService sectionyService = factory.GetSectionService();
                clinic = sectionyService.Get(_ID);
                if (clinic != null)
                {
                    txtAbbreviations.Text = clinic.Abbreviation;
                    ddlStopCode.SelectedIndex = ddlStopCode.Items.IndexOf(ddlStopCode.Items.FindByText(clinic.DSSPrimaryStopCode));
                    if (clinic.Service != null)
                    {
                        ddlServiceType.SelectedIndex = ddlServiceType.Items.IndexOf(ddlServiceType.Items.FindByValue(clinic.Service.Id.ToString()));
                    }
                        //txtDssCode.Text = clinic.DSSPrimaryStopCode;
                    //txtDSSCreditStopCode.Text = clinic.DSSCreditStopCode;
                    txtLocation.Text = clinic.Location;
                    this.txHours.Text = clinic.Hours;
                    txName.Text = clinic.Name;

                    UISession.Helper.GetUserSession(Page).Clinic = clinic;
                }
            }
            //return clinic; 

        }


        private void UpdateClinic()
        {
            try
            {
                UserSession userSession = Helper.GetUserSession(Page);
                Section clinic = new Section();
                if (userSession != null)
                {

                    Shared.Model.Site currentSite = userSession.CurrentSite;
                    Factory factory = Helper.GetFactory(Page);
                    MedRed.Services.Interfaces.ISectionService sectionyService = factory.GetSectionService();
                    clinic = sectionyService.Get(Convert.ToInt16(lblId.Text));
                    if (clinic != null)
                    {

                        clinic.Abbreviation = txtAbbreviations.Text;
                        clinic.DSSPrimaryStopCode = ddlStopCode.SelectedItem.ToString();
                        //clinic.DSSCreditStopCode = txtDSSCreditStopCode.Text;
                        clinic.Location = txtLocation.Text;
                        clinic.Hours = this.txHours.Text;
                        clinic.Name = txName.Text;
                        Service s = new Service();
                        s.Id = ddlServiceType.SelectedValueAsInt();
                        s.Name = ddlServiceType.SelectedItem.ToString();
                        clinic.Service = s;
                        sectionyService.Update(clinic);

                        Response.Redirect("ClinicList.aspx?id=" + clinic.Facility.Id.ToString());
                    }
                }

            }
            catch (Exception exep)
            {
                //Logging here
            }
            
        }

        //protected Section GetSection(int i)
        //{
        //    Factory factory = Helper.GetFactory(Page);
        //    MedRed.Services.Interfaces.INationalSystemService sectionService = factory.GetNationalSystemService();
        //    Service service = sectionService.GetServices();
        //    return service;
        //}

        protected void Button1_Click(object sender, EventArgs e)
        {
            InsertClinic();
        }

        protected void btnUpdate_Click(object sender, EventArgs e)
        {
            UpdateClinic();
        }

      
       

    }
}