﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.Administration
{
    public partial class ClinicDetails : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            ObjectDataSource1.CacheDuration = 0;

            if (Page.IsPostBack != true)
            {
                UISession.Helper.GetUserSession(Page).CurrentResource = null;
                string clinicID = Helper.GetQueryString(Request.QueryString["id"]);
                TemplatesLink.NavigateUrl = "~\\Administration\\Templates\\TemplateList.aspx?facility=N&id=" + clinicID;
                ResourcesLink.NavigateUrl = "~\\Administration\\Resources\\ResourceList.aspx?id=" + clinicID;
                lnkAppointmentTypes.NavigateUrl = "~\\Administration\\Schedules\\ApointmentTypeListaspx.aspx?id=" + clinicID;
            }

            Section clinic = GetClinic(Request.QueryString["id"]);
            
            Button button = (Button)DetailsView1.FindControl("ActivateButton");
            
            if (clinic.Active)
            {
                button.Text = "De-Activate";
            }
            else
            {
                button.Text = "Activate";
            }
        }


        /// <summary>
        /// Get Section (Clinic)
        /// </summary>
        /// <param name="id">Section ID</param>
        /// <returns>Section</returns>
        public Section GetClinic(string id)
        {
            Section clinic = new Section();

            int clinicID = 0;
            Int32.TryParse(id, out clinicID);

            if (clinicID > 0)
            {
                UserSession userSession = Helper.GetUserSession(Page);
                Factory factory = Helper.GetFactory(Page);
                MedRed.Services.Interfaces.ISectionService sectionService = factory.GetSectionService();
                clinic = sectionService.Get(clinicID);
                //MedRed.Services.Interfaces.INationalSystemService natService = factory.GetNationalSystemService();
                UISession.Helper.GetUserSession(Page).Clinic = clinic;
                //Service s = natService.get
            }
            return clinic;
        }

        

        protected void ActivateButton_Click(object sender, EventArgs e)
        {
            try
            {
                Section clinic = GetClinic(Request.QueryString["id"]);

                UserSession userSession = Helper.GetUserSession(Page);
                Factory factory = Helper.GetFactory(Page);
                MedRed.Services.Interfaces.ISectionService sectionService = factory.GetSectionService();


                clinic.Active = !clinic.Active;

                sectionService.Update(clinic);

                //ClinicDataSource.Select();

                Button button = (Button)DetailsView1.FindControl("ActivateButton");

                if (clinic.Active)
                {
                    button.Text = "De-Activate";
                }
                else
                {
                    button.Text = "Activate";
                }

            }
            catch (Exception exept)
            {
                //Logging
            }
            Response.Redirect(Request.RawUrl);
          }
    }
}