﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using MedRed.Services;
using Shared.Model.Config.MDWS;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;

using System.Collections.ObjectModel;

namespace BT.Health.SchedulingWeb.Account
{
    public partial class Login : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            //GetPageStructureSql();            

        }

        protected void Page_PreRender(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                TextBox UserName = LoginUser.RecursiveFindControl("UserName") as TextBox;

                if (UserName != null)
                    UserName.Focus();
            }
        }

        protected void LoginUser_Authenticate(object sender, AuthenticateEventArgs e)
        {
            if (Page.IsValid)
            {
                // attempt to log-on user
                Factory factory = Factory.GetFactory(MDWSConfiguration_ConfigHelper.GetDefaultConfig());
                var accountService = factory.GetAccountService();
                User user = accountService.LogOn(LoginUser.UserName, LoginUser.Password);

                // if we get a user - success
                if (user != null)
                {
                    // create a new session to add user data
                    Session["UserSession"] = new UserSession();

                    //------------------------------------------------
                    // save user in session
                    UISession.Helper.SetCurrentUserAccount(Page, user);

                    //------------------------------------------------
                    // get site service to set our default VISTA site
                    var siteService = factory.GetSiteService();
                    var defaultVistaSite = siteService.GetFromVistaSiteId(UISession.Helper.DefaultVistaId);

                    if (defaultVistaSite != null)
                        UISession.Helper.GetUserSession(Page).CurrentSite = defaultVistaSite;

                    FormsAuthentication.SetAuthCookie(LoginUser.UserName, false);
                    FormsAuthentication.RedirectFromLoginPage(LoginUser.UserName, false);
                }

            }
        }

        protected void LoginButton_Click(object sender, EventArgs e)
        {
            //causes postback only
        }

        void GetPageStructureSql()
        {
            System.IO.DirectoryInfo di = new System.IO.DirectoryInfo(MapPath("~/"));

            List<Pair> aspxPages = new List<Pair>();


            RecursiveGetPageStructureSql(di, "/", aspxPages);
            // create SQL
            System.Text.StringBuilder sb = new System.Text.StringBuilder();

            sb.AppendLine("IDENTITY INSERT UiPageNavigation ON");

            int n = 1;

            foreach (var p in aspxPages)
            {
                sb.AppendLine("INSERT INTO UiPageNavigation (Id, PageAddress, PageTite, BreadcrumbText, ParentPageId, PageHelp) VALUES(" +
                            n.ToString() + ",'" + p.First + "','" + p.Second + "','',null,null)");

                n += 1;
            }

            sb.AppendLine("IDENTITY INSERT UiPageNavigation OFF");

            using (var file = System.IO.File.CreateText(MapPath("~/App_Data/PageNames.sql")))
            {
                file.Write(sb.ToString());
                file.Flush();
                file.Close();
            }

        }

        void RecursiveGetPageStructureSql(System.IO.DirectoryInfo di, string path, List<Pair> list)
        {
            var aspxFiles = di.GetFiles("*.aspx").ToList();

            foreach (var aspxFile in aspxFiles)
                list.Add(new Pair(path + aspxFile.Name, aspxFile.Name));


            var children = di.GetDirectories();

            foreach (var child in children)
                RecursiveGetPageStructureSql(child, path + child.Name + "/", list);
        }

    }
}
