﻿<%@ Page Title="Log In" Language="C#" MasterPageFile="Account.master" AutoEventWireup="true"
    CodeBehind="Login.aspx.cs" Inherits="BT.Health.SchedulingWeb.Account.Login" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <div style="margin: 0 auto; width: 480px;">
        <div class="titleLeft">
            <h2 style="margin-left: 60px;">Veterans Affairs
            </h2>
            <h3 style="margin-left: 60px;">Scheduling Portal
            </h3>
        </div>
        <div style="clear: both;"></div>
        <div>
            <asp:Login ID="LoginUser" runat="server" EnableViewState="false"
                RenderOuterTable="false" OnAuthenticate="LoginUser_Authenticate">
                <LayoutTemplate>
                    <span class="failureNotification">
                        <asp:Literal ID="FailureText" runat="server"></asp:Literal>
                    </span>
                    <asp:ValidationSummary ID="LoginUserValidationSummary" runat="server" CssClass="failureNotification"
                        ValidationGroup="LoginUserValidationGroup" Height="72px" Width="872px" />
                    <asp:Panel ID="Panel1" runat="server" DefaultButton="LoginButton">
                        <fieldset class="login">
                            <legend>Please log in</legend>
                            <p>
                                <asp:Label ID="UserNameLabel" runat="server" AssociatedControlID="UserName">Username:</asp:Label>
                                <asp:TextBox ID="UserName" runat="server" CssClass="textEntry"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="UserNameRequired" runat="server" ControlToValidate="UserName"
                                    CssClass="failureNotification" ErrorMessage="User Name is required." ToolTip="User Name is required."
                                    ValidationGroup="LoginUserValidationGroup">*</asp:RequiredFieldValidator>
                            </p>
                            <p>
                                <asp:Label ID="PasswordLabel" runat="server" AssociatedControlID="Password">Password:</asp:Label>
                                <asp:TextBox ID="Password" runat="server" CssClass="passwordEntry" TextMode="Password"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="PasswordRequired" runat="server" ControlToValidate="Password"
                                    CssClass="failureNotification" ErrorMessage="Password is required." ToolTip="Password is required."
                                    ValidationGroup="LoginUserValidationGroup">*</asp:RequiredFieldValidator>
                            </p>
                            <p style="text-align: right;">
                                <asp:Button ID="LoginButton" runat="server" CommandName="Login" Text="Log In"
                                    ValidationGroup="LoginUserValidationGroup" OnClick="LoginButton_Click" />
                            </p>
                        </fieldset>
                    </asp:Panel>
                </LayoutTemplate>
            </asp:Login>
        </div>
    </div>
</asp:Content>
